/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.arga;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformerParameters;
import java.util.Locale;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.transformation.SimpleTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.extraction.builders.ExtractParametersBuilder;
import net.fichotheque.tools.misc.ThesaurusMessageLocalisation;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;

public class JagaLocalisation
implements UserLangContext {
    private static final SubsetKey jagaPageSubsetKey = SubsetKey.build((short)1, (String)"jagapage");
    private final LangPreference langPreference;
    private final Lang lang;
    private Thesaurus jagaLoc;
    private MessageLocalisation messageLocalisation;
    private ExtractionContext extractionContext;
    private Corpus jagapageCorpus;
    private BdfServer bdfServer;
    private SimpleTemplate sectionSimpleTemplate;

    public JagaLocalisation(BdfServer bdfServer, Lang lang) {
        this.lang = lang;
        this.langPreference = LocalisationUtils.toLangPreference((Lang)lang);
        this.init(bdfServer);
    }

    public Lang getLang() {
        return this.lang;
    }

    public Lang getWorkingLang() {
        return this.lang;
    }

    public Locale getFormatLocale() {
        return this.lang.toLocale();
    }

    public LangPreference getLangPreference() {
        return this.langPreference;
    }

    public MessageLocalisation getMessageLocalisation() {
        return this.messageLocalisation;
    }

    public ExtractionContext getExtractionContext() {
        return this.extractionContext;
    }

    public String getText(String key) {
        return this.messageLocalisation.toString(key);
    }

    public String getTextWithLine(String key) {
        String source = this.messageLocalisation.toString(key);
        StringBuilder buf = new StringBuilder();
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char carac = source.charAt(i);
            if (carac == '\u00a7') {
                buf.append("\n\n");
                continue;
            }
            buf.append(carac);
        }
        return buf.toString();
    }

    public String getFicheText(int id) {
        FicheMeta ficheMeta = this.jagapageCorpus.getFicheMetaById(id);
        if (ficheMeta == null) {
            return null;
        }
        FicheAPI fiche = this.jagapageCorpus.getFicheAPI(ficheMeta, true);
        FieldKey fieldKey = FieldKey.build((short)3, (String)("texte" + this.lang.toString()));
        Section section = fiche.getSection(fieldKey);
        ExtractParameters extractParameters = ExtractParametersBuilder.init((ExtractionContext)this.extractionContext).setExtractVersion(1).setWithEmpty(false).toExtractParameters();
        String extractionString = ExtractionXMLUtils.ficheBlocksToExtractionString((FicheBlocks)section, (ExtractParameters)extractParameters, (SubsetKey)jagaPageSubsetKey);
        TransformerParameters transformerParameters = TransformerParameters.build((Lang)this.lang).check(this.sectionSimpleTemplate.getAttributes()).put("BDF_FICHOTHEQUEPATH", (Object)"../../");
        return this.sectionSimpleTemplate.transform(extractionString, transformerParameters.getMap());
    }

    private void init(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
        Fichotheque fichotheque = bdfServer.getFichotheque();
        this.jagaLoc = FichothequeUtils.getThesaurus((Fichotheque)fichotheque, (String)"jagasiteloc");
        this.messageLocalisation = new ThesaurusMessageLocalisation(this.jagaLoc, this.lang, bdfServer.getThesaurusLangChecker(), this.lang.toLocale());
        this.extractionContext = BdfServerUtils.initExtractionContextBuilder((BdfServer)bdfServer, (LangContext)LocalisationUtils.toUserLangContext((Lang)this.lang), (PermissionSummary)PermissionUtils.FICHOTHEQUEADMIN_PERMISSIONSUMMARY).toExtractionContext();
        this.jagapageCorpus = (Corpus)fichotheque.getSubset(jagaPageSubsetKey);
        this.sectionSimpleTemplate = bdfServer.getTransformationManager().getSimpleTemplate(TemplateKey.toDefault((TransformationKey)TransformationKey.SECTION_INSTANCE), true);
    }
}

