/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.arga;

import fr.exemole.bdfext.arga.Arga;
import fr.exemole.bdfext.arga.JagaLocalisation;
import fr.exemole.bdfext.arga.pages.JagaGabaritResolver;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.email.tools.FicheSendTools;
import fr.exemole.bdfserver.tools.EditionTools;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.html.GabaritHtmlProducer;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.request.AppendableRequestMap;
import net.mapeadores.util.request.RequestConf;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;

public class ArgaBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private static final SubsetKey contribSubsetKey = SubsetKey.build((short)1, (String)"jagacontribproposition");
    private static final FieldKey courrielFieldKey = FieldKey.build((String)"propriete_courriel");
    private static final AttributeKey expediteurAttributeKey = AttributeKey.build((CheckedNameSpace)CheckedNameSpace.build((CharSequence)"CONFIRM"), (CharSequence)"idexpediteur");
    private final Map<String, String> instructionMap;
    private final RequestMap requestMap;
    private final BdfServer bdfServer;

    public ArgaBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> instructionMap) {
        this.instructionMap = instructionMap;
        this.requestMap = requestMap;
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 1;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        Lang lang;
        String langString = this.instructionMap.get("lang");
        try {
            lang = Lang.parse((String)langString);
        }
        catch (ParseException pe) {
            return null;
        }
        JagaLocalisation jagaLocalisation = new JagaLocalisation(this.bdfServer, lang);
        String page = this.instructionMap.get("page");
        String type = this.instructionMap.get("type");
        FicheMeta ficheMeta = null;
        BdfParameters adminBdfParameters = BdfUserUtils.getFirstAdminBdfParameters((BdfServer)this.bdfServer);
        if (page.equals("resultat")) {
            RequestConf requestConf = this.getRequestConf(page, type);
            AppendableRequestMap mergedRequestMap = RequestUtils.merge((RequestMap)this.requestMap, (List)requestConf.getSupplementaryParameterList());
            try (EditSession editSession = this.bdfServer.initEditSession("ext:Arga");){
                ficheMeta = EditionTools.createFiche((EditSession)editSession, (BdfParameters)adminBdfParameters, (SubsetKey)contribSubsetKey, (RequestMap)mergedRequestMap);
            }
            String rootUrl = "";
            this.envoi(ficheMeta, requestConf, type, jagaLocalisation, rootUrl);
        }
        return this.getResponseHandler(page, type, adminBdfParameters, jagaLocalisation, ficheMeta);
    }

    private ResponseHandler getResponseHandler(String page, String type, BdfParameters bdfParameters, JagaLocalisation jagaLocalisation, FicheMeta ficheMeta) {
        try {
            String gabaritString = this.getGabarit(page, type);
            if (gabaritString == null) {
                return SimpleResponseHandler.init((String)("Ressource introuvable : " + page + "-" + type + ".html"));
            }
            JagaGabaritResolver jagaGabaritResolver = new JagaGabaritResolver(bdfParameters, jagaLocalisation, (Corpus)this.bdfServer.getFichotheque().getSubset(contribSubsetKey), ficheMeta, this.instructionMap);
            return HtmlResponseHandler.init((HtmlProducer)new GabaritHtmlProducer(gabaritString, (InstructionResolver)jagaGabaritResolver));
        }
        catch (IOException ioe) {
            return SimpleResponseHandler.init((String)("IOException : " + ioe.getMessage()));
        }
    }

    private String getGabarit(String page, String type) throws IOException {
        DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(Arga.EXTENSION_RESOURCE_ROOT.buildChild("private/" + page + "-" + type + ".html"));
        if (docStream == null) {
            return null;
        }
        try (InputStream is = docStream.getInputStream();){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    private RequestConf getRequestConf(String page, String type) {
        RequestConf requestConf;
        block9: {
            DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(Arga.EXTENSION_RESOURCE_ROOT.buildChild("private/" + page + "-" + type + ".xml"));
            if (docStream == null) {
                return RequestUtils.EMPTY_REQUESTCONF;
            }
            InputStream is = docStream.getInputStream();
            try {
                Document document = DOMUtils.readDocument((InputStream)is);
                requestConf = RequestUtils.parseRequestConf((Document)document);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            is.close();
        }
        return requestConf;
    }

    private void envoi(FicheMeta ficheMeta, RequestConf requestConf, String type, JagaLocalisation jagaLocalisation, String rootUrl) {
        String sujet = jagaLocalisation.getText("form_sujet_envoi");
        String texte = jagaLocalisation.getTextWithLine("form_message_envoi");
        Attribute attribute = requestConf.getAttributes().getAttribute(expediteurAttributeKey);
        if (attribute == null) {
            return;
        }
        BdfUser expediteur = null;
        try {
            Redacteur redacteur = SphereUtils.parse((Fichotheque)this.bdfServer.getFichotheque(), (String)attribute.getFirstValue());
            expediteur = this.bdfServer.createBdfUser(redacteur);
            expediteur.putParameter("bdf.session.rooturl", (Object)rootUrl);
        }
        catch (SphereUtils.RedacteurLoginException rle) {
            throw new IllegalArgumentException(rle);
        }
        if (expediteur == null) {
            throw new IllegalArgumentException("Undefined expediteur");
        }
        FicheSendTools.sendFiche((BdfServer)this.bdfServer, (BdfUser)expediteur, (FicheMeta)ficheMeta, (FieldKey)courrielFieldKey, (String)sujet, (String)texte);
    }
}

