/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.utils.instructions;

import fr.exemole.bdfext.utils.instructions.UtilsInstruction;
import fr.exemole.bdfext.utils.migration.MigrationEngine;
import fr.exemole.bdfext.utils.migration.MigrationParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.utils.FicheUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.text.StringUtils;

public class Migration
extends UtilsInstruction {
    @Override
    public Object runInstruction() {
        String paramFile = this.requestMap.getParameter("params");
        if (paramFile == null) {
            return "Param\u00e8tre params non d\u00e9fini";
        }
        File file = new File(paramFile);
        if (!file.exists()) {
            return "Fichier introuvable : " + paramFile;
        }
        if (file.isDirectory()) {
            return "Le fichier est un r\u00e9pertoire : " + paramFile;
        }
        ArrayList<String> errorList = new ArrayList<String>();
        ParamsParser parser = new ParamsParser(errorList);
        try {
            parser.parseFile(file);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        if (errorList.size() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("Errors: ");
            for (String error : errorList) {
                buf.append('\n');
                buf.append(error);
            }
            return buf.toString();
        }
        MigrationEngine migrationEngine = new MigrationEngine(parser.getMigrationParameters());
        migrationEngine.run(this.bdfUser);
        return "Migration faite";
    }

    class ParamsParser {
        MigrationParameters migrationParameters = new MigrationParameters();
        List<String> errorList;
        List<FieldToFieldConverter> fieldToFieldConverterList = new ArrayList<FieldToFieldConverter>();

        ParamsParser(List<String> errorList) {
            this.errorList = errorList;
            this.migrationParameters.setDestinationBdfServer(Migration.this.bdfServer);
        }

        public MigrationParameters getMigrationParameters() {
            return this.migrationParameters;
        }

        void parseFile(File f) throws IOException {
            try (BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));){
                String ligne;
                while ((ligne = buf.readLine()) != null) {
                    if ((ligne = ligne.trim()).length() == 0) continue;
                    int idx = ligne.indexOf(61);
                    if (idx != -1) {
                        String key = ligne.substring(0, idx).trim();
                        String value = ligne.substring(idx + 1).trim();
                        if (key.length() == 0) {
                            this.errorList.add("Missing key : =" + value);
                            continue;
                        }
                        if (value.length() == 0) {
                            this.errorList.add("Missing value : " + key + "=");
                            continue;
                        }
                        this.checkKey(key, value);
                        continue;
                    }
                    int idx2 = ligne.indexOf(62);
                    if (idx2 == -1) continue;
                    String key1 = ligne.substring(0, idx2).trim();
                    String key2 = ligne.substring(idx2 + 1).trim();
                    if (key1.length() == 0) {
                        this.errorList.add("Missing key1 : >" + key2);
                        continue;
                    }
                    if (key2.length() == 0) {
                        this.errorList.add("Missing key2 : " + key1 + ">");
                        continue;
                    }
                    this.addFicheConverter(key1, key2);
                }
            }
            this.migrationParameters.setFicheConverterList(this.fieldToFieldConverterList);
        }

        void checkKey(String key, String value) {
            if (key.equals("origine_subset")) {
                try {
                    SubsetKey origineKey = SubsetKey.parse((String)value);
                    this.migrationParameters.setOrigineSubsetKey(origineKey);
                }
                catch (ParseException pe) {
                    this.errorList.add("No subset Key : " + value + " (" + key + ")");
                }
            } else if (key.equals("destination_subset")) {
                try {
                    SubsetKey destinationKey = SubsetKey.parse((String)value);
                    this.migrationParameters.setDestinationSubsetKey(destinationKey);
                }
                catch (ParseException pe) {
                    this.errorList.add("No subset Key : " + value + " (" + key + ")");
                }
            } else if (key.equals("origine_bdfdatadir")) {
                File dir = new File(value);
                if (!dir.exists()) {
                    this.errorList.add("origine_bdfdatadir / path does not exist : " + value);
                }
                if (!dir.isDirectory()) {
                    this.errorList.add("origine_bdfdatadir / path is not a directory : " + value);
                }
                this.migrationParameters.setOrigineFichothequeDir(dir);
            } else if (key.equals("redacteurs")) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (String token : StringUtils.getTechnicalTokens((String)value, (boolean)true)) {
                    if (SphereUtils.testGlobalId((String)token)) {
                        list.add(new Personne(token));
                        continue;
                    }
                    list.add(new Item(token));
                }
                this.migrationParameters.setRedacteursList(FicheUtils.toFicheItems(list));
            } else {
                this.errorList.add("Unknwon key : " + key);
            }
        }

        private void addFicheConverter(String key1, String key2) {
            FieldKey fieldKey2;
            FieldKey fieldKey1;
            try {
                fieldKey1 = FieldKey.parse((String)key1);
            }
            catch (ParseException pe) {
                this.errorList.add("No field key : " + key1);
                return;
            }
            try {
                fieldKey2 = FieldKey.parse((String)key2);
            }
            catch (ParseException pe) {
                this.errorList.add("No field key : " + key2);
                return;
            }
            try {
                FieldToFieldConverter fieldToFieldConverter = FieldToFieldConverter.getInstance((FieldKey)fieldKey1, (FieldKey)fieldKey2, (MultiMessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER);
                this.fieldToFieldConverterList.add(fieldToFieldConverter);
            }
            catch (IllegalArgumentException iae) {
                this.errorList.add("No conversion : " + key1 + " / " + key2);
            }
        }
    }
}

