/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.cours;

import net.fichotheque.alias.AliasChecker;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.tools.alias.AliasUtils;
import net.mapeadores.util.logging.MessageHandler;

public class CoursUtils {
    public static final AliasChecker COURS_ALIASCHECKER = new CoursAliasChecker();

    private CoursUtils() {
    }

    public static CorpusField getMontantsPivots(AliasHolder aliasHolder, String corpusAlias) {
        if (corpusAlias.equals("cours")) {
            return aliasHolder.getCorpusField("cours_montantspivots");
        }
        if (corpusAlias.equals("depense")) {
            return aliasHolder.getCorpusField("depense_montantspivots");
        }
        if (corpusAlias.equals("apport")) {
            return aliasHolder.getCorpusField("apport_montantspivots");
        }
        if (corpusAlias.equals("avance")) {
            return aliasHolder.getCorpusField("avance_montantspivots");
        }
        return null;
    }

    private static class CoursAliasChecker
    implements AliasChecker {
        private CoursAliasChecker() {
        }

        public short checkCorpusAlias(String alias) {
            switch (alias) {
                case "cours": {
                    return 2;
                }
            }
            return 0;
        }

        public short checkThesaurusAlias(String alias) {
            return 0;
        }

        public short checkFieldAlias(String corpusAlias, String fieldAlias) {
            if (corpusAlias.equals("cours")) {
                switch (fieldAlias) {
                    case "cours_date": 
                    case "cours_monnaie": 
                    case "cours_montantspivots": {
                        return 2;
                    }
                }
                return 0;
            }
            if (corpusAlias.equals("depense")) {
                switch (fieldAlias) {
                    case "depense_montantspivots": {
                        return 1;
                    }
                }
                return 0;
            }
            if (corpusAlias.equals("apport")) {
                switch (fieldAlias) {
                    case "apport_montantspivots": {
                        return 1;
                    }
                }
                return 0;
            }
            if (corpusAlias.equals("avance")) {
                switch (fieldAlias) {
                    case "avance_montantspivots": {
                        return 1;
                    }
                }
                return 0;
            }
            return 0;
        }

        public boolean testFieldValidity(String alias, CorpusField corpusField, MessageHandler messageHandler) {
            switch (alias) {
                case "cours_date": {
                    return AliasUtils.testDatationPropriete((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
                case "cours_monnaie": {
                    return AliasUtils.testItemPropriete((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
                case "cours_montantspivots": 
                case "depense_montantspivots": 
                case "apport_montantspivots": 
                case "avance_montantspivots": {
                    return AliasUtils.testMontantInformation((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
            }
            return false;
        }
    }
}

