/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.LigneKey;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.tools.core.AvanceInfoBuilder;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfext.scarabe.tools.cours.CoursUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.PointeurUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.FuzzyDate;

public class LigneBuilder {
    private LigneBuilder() {
    }

    public static Ligne build(FichePointeur lignePointeur, ScarabeContext scarabeContext, Mouvement mouvement, String corpusAlias) {
        return LigneBuilder.build(lignePointeur, scarabeContext, mouvement, corpusAlias, false);
    }

    public static Ligne buildSoldeAvance(FichePointeur lignePointeur, ScarabeContext scarabeContext, Mouvement mouvement) {
        return LigneBuilder.build(lignePointeur, scarabeContext, mouvement, "avance", true);
    }

    private static Ligne build(FichePointeur lignePointeur, ScarabeContext scarabeContext, Mouvement mouvement, String corpusAlias, boolean isSoldeAvance) {
        FicheItem dateprevue;
        CorpusField dateprevueField;
        FicheItem beneficiaire;
        CorpusField beneficiaireField;
        FicheItems ficheItems;
        CorpusField montantspivotsField;
        AliasHolder coursAliasHolder;
        AliasHolder coreAliasHolder = scarabeContext.getCoreAliasHolder();
        ArrayList<Message> errorMessageList = new ArrayList<Message>();
        FicheMeta ficheMeta = (FicheMeta)lignePointeur.getCurrentSubsetItem();
        LigneKey ligneKey = LigneKey.get(corpusAlias, ficheMeta.getId(), isSoldeAvance);
        InternalLigne ligne = new InternalLigne(ligneKey, mouvement, ficheMeta);
        Datation ligneDate = PointeurUtils.getDatation((FichePointeur)lignePointeur, (CorpusField)CoreUtils.getDate(coreAliasHolder, corpusAlias));
        if (isSoldeAvance) {
            ligne.setDate(mouvement.getDate());
        } else if (ligneDate == null) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.empty.scarabe.date"));
        } else {
            FuzzyDate date = ligneDate.getDate();
            if (date.getType() != 5) {
                errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.wrong.scarabe.datetype"));
            } else {
                ligne.setDate(date);
            }
        }
        Montant montant = PointeurUtils.getMontant((FichePointeur)lignePointeur, (CorpusField)CoreUtils.getMontant(coreAliasHolder, corpusAlias));
        if (montant == null) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.empty.scarabe.montant"));
        } else {
            Montant mouvementMontant = mouvement.getMontant();
            ExtendedCurrency currency = montant.getCurrency();
            if (mouvementMontant != null && !currency.equals((Object)mouvementMontant.getCurrency())) {
                errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.unsupported.scarabe.differentcurrency"));
            } else {
                ligne.montant = montant;
                long val = montant.toMoneyLong();
                if (LigneBuilder.isDepense(corpusAlias, isSoldeAvance)) {
                    val = -val;
                }
                ligne.computeMoneyLong = val;
            }
        }
        FicheItem libelleItem = (FicheItem)lignePointeur.getValue(CoreUtils.getLibelle(coreAliasHolder, corpusAlias));
        String libelle = "";
        if (libelleItem != null && libelleItem instanceof Item) {
            libelle = ((Item)libelleItem).getValue();
        }
        if (libelle.equals("")) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.empty.scarabe.libelle"));
        } else {
            ligne.libelle = libelle;
        }
        Collection ficheLiaisons = CroisementUtils.filter((Croisements)lignePointeur.getCroisements((Subset)coreAliasHolder.getCorpus("mouvement")), (String)"", (int)-1);
        int poids1Count = 0;
        int poids2Count = 0;
        FicheMeta ficheMouvementDeCreation = null;
        FicheMeta ficheMouvementDeSolde = null;
        for (Liaison liaison : ficheLiaisons) {
            int poids = liaison.getLien().getPoids();
            if (poids == 1) {
                ++poids1Count;
                if (ficheMouvementDeCreation != null) continue;
                ficheMouvementDeCreation = (FicheMeta)liaison.getSubsetItem();
                continue;
            }
            if (poids != 2) continue;
            if (ficheMouvementDeSolde == null) {
                ficheMouvementDeSolde = (FicheMeta)liaison.getSubsetItem();
            }
            ++poids2Count;
        }
        if (poids1Count != 1) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.unsupported.scarabe.toomany_mouvement"));
        }
        if (poids2Count > 1 && corpusAlias.equals("avance")) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.unsupported.scarabe.toomany_mouvement"));
        }
        if (ligne.date != null && mouvement.getDate() != null && !ligne.date.equals((Object)mouvement.getDate())) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.unsupported.scarabe.notmatchingdate"));
        }
        if (corpusAlias.equals("avance")) {
            AvanceInfo avanceInfo = AvanceInfoBuilder.build(lignePointeur, coreAliasHolder, ficheMouvementDeCreation, ficheMouvementDeSolde);
            ligne.avanceInfo = avanceInfo;
            if (avanceInfo.hasError()) {
                errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.unsupported.scarabe.witherrors_avance"));
            }
        }
        if ((coursAliasHolder = scarabeContext.getCoursAliasHolder()) != null && (montantspivotsField = CoursUtils.getMontantsPivots(coursAliasHolder, corpusAlias)) != null && (ficheItems = (FicheItems)lignePointeur.getValue(montantspivotsField)) != null) {
            for (FicheItem ficheItem : ficheItems) {
                if (!(ficheItem instanceof Montant)) continue;
                Montant pivotMontant = (Montant)ficheItem;
                ExtendedCurrency pivotCurrency = pivotMontant.getCurrency();
                long pivotVal = pivotMontant.toMoneyLong();
                if (LigneBuilder.isDepense(corpusAlias, isSoldeAvance)) {
                    pivotVal = -pivotVal;
                }
                ligne.addPivot(pivotCurrency, pivotVal);
            }
        }
        if ((beneficiaireField = CoreUtils.getBeneficiaire(coreAliasHolder, corpusAlias)) != null && (beneficiaire = (FicheItem)lignePointeur.getValue(beneficiaireField)) != null) {
            ligne.beneficiaireString = CoreUtils.toBeneficiaireString(beneficiaire, lignePointeur.getFichotheque());
        }
        if ((dateprevueField = CoreUtils.getDateprevue(coreAliasHolder, corpusAlias)) != null && (dateprevue = (FicheItem)lignePointeur.getValue(dateprevueField)) != null) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.unsupported.scarabe.notempty_dateprevue"));
        }
        if (!errorMessageList.isEmpty()) {
            ligne.errorMessageList = errorMessageList;
        }
        return ligne;
    }

    private static boolean isDepense(String corpusAlias, boolean isSoldeAvance) {
        if (corpusAlias.equals("depense")) {
            return true;
        }
        if (corpusAlias.equals("apport")) {
            return false;
        }
        if (corpusAlias.equals("avance")) {
            return !isSoldeAvance;
        }
        throw new SwitchException(corpusAlias);
    }

    private static class InternalLigne
    implements Ligne {
        private final FicheMeta ficheMeta;
        private final Mouvement mouvement;
        private final LigneKey ligneKey;
        private FuzzyDate date;
        private List<Message> errorMessageList;
        private long computeMoneyLong;
        private Montant montant;
        private String libelle = "";
        private AvanceInfo avanceInfo;
        private Map<ExtendedCurrency, Long> moneyLongMap;
        private String beneficiaireString = "";

        private InternalLigne(LigneKey ligneKey, Mouvement mouvement, FicheMeta ficheMeta) {
            this.ficheMeta = ficheMeta;
            this.mouvement = mouvement;
            this.ligneKey = ligneKey;
        }

        @Override
        public Mouvement getMouvement() {
            return this.mouvement;
        }

        @Override
        public int getId() {
            return this.ficheMeta.getId();
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public FuzzyDate getDate() {
            return this.date;
        }

        @Override
        public Montant getMontant() {
            return this.montant;
        }

        @Override
        public String getLibelle() {
            return this.libelle;
        }

        @Override
        public LigneKey getLigneKey() {
            return this.ligneKey;
        }

        @Override
        public long getComputeMoneyLong() {
            return this.computeMoneyLong;
        }

        @Override
        public boolean hasError() {
            return this.errorMessageList != null;
        }

        @Override
        public List<Message> getErrorMessageList() {
            if (this.errorMessageList != null) {
                return this.errorMessageList;
            }
            return LocalisationUtils.EMPTY_MESSAGELIST;
        }

        @Override
        public AvanceInfo getAvanceInfo() {
            return this.avanceInfo;
        }

        @Override
        public Long getPivotMoneyLong(ExtendedCurrency currency) {
            if (this.moneyLongMap == null) {
                return null;
            }
            return this.moneyLongMap.get(currency);
        }

        @Override
        public String getBeneficiaireString() {
            return this.beneficiaireString;
        }

        private void addPivot(ExtendedCurrency currency, long moneyLong) {
            if (this.moneyLongMap == null) {
                this.moneyLongMap = new HashMap<ExtendedCurrency, Long>();
            }
            this.moneyLongMap.put(currency, moneyLong);
        }

        private void setDate(FuzzyDate date) {
            this.date = date;
        }
    }
}

