/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.pointeurs.PointeurFactory;

public class DesherenceTest {
    public static final short MOUVEMENT_STATE = 1;
    public static final short AVANCE_STATE = 2;
    public static final short AVENIR_STATE = 3;
    public static final short DESHERENCE_STATE = 4;

    private DesherenceTest() {
    }

    public static short getDepenseDesherenceState(FichePointeur fichePointeur, Corpus mouvementCorpus, Corpus avanceCorpus, CorpusField dateprevueField) {
        if (DesherenceTest.withLiaison(fichePointeur, (Subset)mouvementCorpus)) {
            return 1;
        }
        if (DesherenceTest.withLiaison(fichePointeur, (Subset)avanceCorpus)) {
            return 2;
        }
        Object value = fichePointeur.getValue(dateprevueField);
        if (value != null) {
            return 3;
        }
        return 4;
    }

    public static short getApportDesherenceState(FichePointeur fichePointeur, Corpus mouvementCorpus) {
        if (DesherenceTest.withLiaison(fichePointeur, (Subset)mouvementCorpus)) {
            return 1;
        }
        return 4;
    }

    public static short getAvanceDesherenceState(FichePointeur fichePointeur, Corpus mouvementCorpus) {
        for (Liaison liaison : fichePointeur.getStandardLiaisons((Subset)mouvementCorpus)) {
            int poids = liaison.getLien().getPoids();
            if (poids != 1 && poids != 2) continue;
            return 1;
        }
        return 4;
    }

    public static boolean isDesherenceFiche(ScarabeContext scarabeContext, FicheMeta ficheMeta) {
        AliasHolder coreAliasHolder = scarabeContext.getCoreAliasHolder();
        Corpus mouvementCorpus = coreAliasHolder.getCorpus("mouvement");
        Corpus avanceCorpus = coreAliasHolder.getCorpus("avance");
        Corpus depenseCorpus = coreAliasHolder.getCorpus("depense");
        Corpus apportCorpus = coreAliasHolder.getCorpus("apport");
        Corpus currentCorpus = ficheMeta.getCorpus();
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)currentCorpus);
        fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
        short state = 0;
        if (currentCorpus.equals(depenseCorpus)) {
            CorpusField dateprevueField = coreAliasHolder.getCorpusField("depense_dateprevue");
            state = DesherenceTest.getDepenseDesherenceState(fichePointeur, mouvementCorpus, avanceCorpus, dateprevueField);
        } else if (currentCorpus.equals(apportCorpus)) {
            state = DesherenceTest.getApportDesherenceState(fichePointeur, mouvementCorpus);
        } else if (currentCorpus.equals(avanceCorpus)) {
            state = DesherenceTest.getAvanceDesherenceState(fichePointeur, mouvementCorpus);
        }
        return state == 4;
    }

    private static boolean withLiaison(FichePointeur fichePointeur, Subset subset) {
        for (Liaison liaison : fichePointeur.getStandardLiaisons(subset)) {
            if (liaison.getLien().getPoids() != 1) continue;
            return true;
        }
        return false;
    }
}

