/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.BanqueRecap;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import java.util.HashMap;
import java.util.Map;

public class BanqueRecapBuilder {
    private BanqueRecapBuilder() {
    }

    public static Map<String, BanqueRecap> fromRecapitulatif(Recapitulatif recapitulatif) {
        HashMap<String, BanqueRecap> resultMap = new HashMap<String, BanqueRecap>();
        for (Recapitulatif.Annee annee : recapitulatif.getAnneeList()) {
            for (Recapitulatif.Mois mois : annee.getMoisList()) {
                for (Recapitulatif.Jour jour : mois.getJourList()) {
                    for (Mouvement mouvement : jour.getMouvementList()) {
                        BanqueRecapBuilder.checkMouvement(mouvement, resultMap);
                    }
                }
            }
        }
        for (BanqueRecap banqueRecap : resultMap.values()) {
            ((InternalBanqueRecap)banqueRecap).initSolde();
        }
        return resultMap;
    }

    private static void checkMouvement(Mouvement mouvement, Map<String, BanqueRecap> resultMap) {
        Banque banque = mouvement.getBanque();
        String codeBanque = banque.getCodeBanque();
        InternalBanqueRecap banqueRecap = (InternalBanqueRecap)resultMap.get(codeBanque);
        if (banqueRecap == null) {
            banqueRecap = new InternalBanqueRecap(banque.getReportMoneyLong());
            resultMap.put(codeBanque, banqueRecap);
        }
        if (mouvement.isDebit()) {
            banqueRecap.addDebit(mouvement.getMontantMoneyLong());
        } else {
            banqueRecap.addCredit(mouvement.getMontantMoneyLong());
        }
    }

    private static class InternalBanqueRecap
    implements BanqueRecap {
        private final long report;
        private long debit;
        private long credit;
        private long solde;

        private InternalBanqueRecap(long report) {
            this.report = report;
        }

        @Override
        public long getReportMoneyLong() {
            return this.report;
        }

        @Override
        public long getDebitMoneyLong() {
            return this.debit;
        }

        @Override
        public long getCreditMoneyLong() {
            return this.credit;
        }

        @Override
        public long getSoldeMoneyLong() {
            return this.solde;
        }

        private void addDebit(long l) {
            this.debit += l;
        }

        private void addCredit(long l) {
            this.credit += l;
        }

        private void initSolde() {
            this.solde = this.report - this.debit + this.credit;
        }
    }
}

