/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.api.core.Banque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.ExtendedCurrency;

public class BanqueBuilder {
    private static final List<String> ERROR_LIST = Collections.emptyList();

    private BanqueBuilder() {
    }

    public static Banque init(Motcle motcle, AliasHolder coreAliasHolder) {
        InternalBanque banque = new InternalBanque(motcle);
        ArrayList<Message> errorMessageList = new ArrayList<Message>();
        Corpus banqueCorpus = coreAliasHolder.getCorpus("banque");
        FicheMeta banqueFiche = banqueCorpus.getFicheMetaById(motcle.getId());
        if (banqueFiche == null) {
            errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.empty.scarabe.banquefiche"));
        } else {
            Montant report = BanqueBuilder.getReport(banqueFiche, coreAliasHolder);
            if (report == null) {
                errorMessageList.add(LocalisationUtils.toMessage((String)"_ error.empty.scarabe.banquereport"));
            } else {
                banque.setReport(report);
            }
        }
        if (!errorMessageList.isEmpty()) {
            banque.errorMessageList = errorMessageList;
        }
        return banque;
    }

    private static Montant getReport(FicheMeta banqueFiche, AliasHolder coreAliasHolder) {
        Object value = banqueFiche.getFicheAPI(false).getValue(coreAliasHolder.getCorpusField("banque_montantreport"));
        if (value == null) {
            return null;
        }
        if (!(value instanceof Montant)) {
            return null;
        }
        return (Montant)value;
    }

    private static class InternalBanque
    implements Banque {
        private final Motcle motcle;
        private final String codeBanque;
        private List<Message> errorMessageList = null;
        private long reportMoneyLong;
        private ExtendedCurrency currency;

        private InternalBanque(Motcle motcle) {
            this.motcle = motcle;
            this.codeBanque = motcle.getIdalpha();
        }

        @Override
        public Motcle getMotcle() {
            return this.motcle;
        }

        @Override
        public String getCodeBanque() {
            return this.codeBanque;
        }

        @Override
        public boolean hasError() {
            return this.errorMessageList != null;
        }

        @Override
        public List<Message> getErrorMessageList() {
            if (this.errorMessageList != null) {
                return this.errorMessageList;
            }
            return LocalisationUtils.EMPTY_MESSAGELIST;
        }

        @Override
        public ExtendedCurrency getCurrency() {
            return this.currency;
        }

        @Override
        public long getReportMoneyLong() {
            return this.reportMoneyLong;
        }

        private void setReport(Montant montant) {
            this.currency = montant.getCurrency();
            this.reportMoneyLong = montant.toMoneyLong();
        }
    }
}

