/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.PointeurUtils;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.primitives.FuzzyDate;

public class AvenirBuilder {
    private static final List<String> EMPTY_ERRORLIST = Collections.emptyList();

    private AvenirBuilder() {
    }

    public static Avenir init(FichePointeur depensePointeur, ScarabeContext scarabeContext, Currencies currencyHolder, CorpusField dateprevueCorpusField) {
        FicheItem beneficiaire;
        AliasHolder coreAliasHolder = scarabeContext.getCoreAliasHolder();
        Object value = depensePointeur.getValue(dateprevueCorpusField);
        ArrayList<Message> errorMessageList = new ArrayList<Message>();
        FuzzyDate date = null;
        if (value == null) {
            throw new IllegalArgumentException("Test must be done before");
        }
        if (value instanceof Datation) {
            date = ((Datation)value).getDate();
        } else {
            AvenirBuilder.addError(errorMessageList, "_ error.wrong.scarabe.dateprevue");
        }
        if (depensePointeur.getValue(coreAliasHolder.getCorpusField("depense_date")) != null) {
            AvenirBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.notempty_date");
        }
        InternalAvenir avenir = new InternalAvenir((FicheMeta)depensePointeur.getCurrentSubsetItem(), errorMessageList);
        avenir.datePrevue = date;
        Montant montant = PointeurUtils.getMontant((FichePointeur)depensePointeur, (CorpusField)coreAliasHolder.getCorpusField("depense_montant"));
        if (montant == null) {
            AvenirBuilder.addError(errorMessageList, "_ error.empty.scarabe.montant");
        } else {
            int currencyIndex = currencyHolder.indexOf((Object)montant.getCurrency());
            avenir.montant = montant;
            long val = montant.toMoneyLong();
            avenir.computeMoneyLong = -val;
            avenir.currencyIndex = currencyIndex;
            if (currencyIndex == -1) {
                AvenirBuilder.addError(errorMessageList, "_ error.unsupported.scarabe.notinlistcurrency");
            }
        }
        FicheItem libelleItem = (FicheItem)depensePointeur.getValue(coreAliasHolder.getCorpusField("depense_libelle"));
        String libelle = "";
        if (libelleItem != null && libelleItem instanceof Item) {
            libelle = ((Item)libelleItem).getValue();
        }
        if (libelle.equals("")) {
            AvenirBuilder.addError(errorMessageList, "_ error.empty.scarabe.libelle");
        } else {
            avenir.libelle = libelle;
        }
        CorpusField beneficiaireField = coreAliasHolder.getCorpusField("depense_beneficiaire");
        if (beneficiaireField != null && (beneficiaire = (FicheItem)depensePointeur.getValue(beneficiaireField)) != null) {
            avenir.beneficiaireString = CoreUtils.toBeneficiaireString(beneficiaire, depensePointeur.getFichotheque());
        }
        return avenir;
    }

    private static void addError(List<Message> errorMessageList, String key) {
        errorMessageList.add(LocalisationUtils.toMessage((String)key));
    }

    private static class InternalAvenir
    implements Avenir {
        private FuzzyDate datePrevue;
        private final FicheMeta ficheMeta;
        private final List<Message> errorMessageList;
        private String libelle = "";
        private String beneficiaireString = "";
        private long computeMoneyLong;
        private Montant montant;
        private int currencyIndex;

        private InternalAvenir(FicheMeta ficheMeta, List<Message> errorMessageList) {
            this.ficheMeta = ficheMeta;
            this.errorMessageList = errorMessageList;
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public FuzzyDate getDatePrevue() {
            return this.datePrevue;
        }

        @Override
        public String getLibelle() {
            return this.libelle;
        }

        @Override
        public String getBeneficiaireString() {
            return this.beneficiaireString;
        }

        @Override
        public int getCurrencyIndex() {
            return this.currencyIndex;
        }

        @Override
        public Montant getMontant() {
            return this.montant;
        }

        @Override
        public long getComputeMoneyLong() {
            return this.computeMoneyLong;
        }

        @Override
        public boolean hasError() {
            return !this.errorMessageList.isEmpty();
        }

        @Override
        public List<Message> getErrorMessageList() {
            return this.errorMessageList;
        }
    }
}

