/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen;

import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.Compte;
import fr.exemole.bdfext.scarabe.api.comptagen.Journal;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;

public class ComptagenLigneBuilder {
    private final String pieceRef;
    private final FuzzyDate date;
    private int ecritureNum;
    private int numerocheque;
    private Compte compte;
    private Compte compteTiers;
    private Compte contrepartie;
    private boolean debit;
    private Journal journal;
    private String modePaiement;
    private long exportMoneyLong;
    private Amount originalAmount;
    private Decimal conversionRate;
    private String libelle;
    private String beneficiaireString;
    private String shortTitle;
    private String facture;

    public ComptagenLigneBuilder(String pieceRef, FuzzyDate date) {
        this.pieceRef = pieceRef;
        this.date = date;
    }

    public ComptagenLigne toComptagenLigne() {
        return new InternalComptagenLigne(this.ecritureNum, this.pieceRef, this.date, this.journal, this.compte, this.compteTiers, this.contrepartie, this.modePaiement, this.libelle, this.beneficiaireString, this.numerocheque, this.debit, this.exportMoneyLong, this.originalAmount, this.conversionRate, this.facture, this.shortTitle);
    }

    public ComptagenLigneBuilder checkLigne(Ligne ligne) {
        this.beneficiaireString = ligne.getBeneficiaireString();
        this.libelle = ligne.getLibelle();
        return this;
    }

    public ComptagenLigneBuilder checkMouvement(Mouvement mouvement) {
        this.beneficiaireString = mouvement.getBeneficiaireString();
        this.libelle = mouvement.getLibelle();
        return this;
    }

    public ComptagenLigneBuilder setEcritureNum(int ecritureNum) {
        this.ecritureNum = ecritureNum;
        return this;
    }

    public ComptagenLigneBuilder setCompte(Compte compte, Compte compteTiers) {
        this.compte = compte;
        this.compteTiers = compteTiers;
        return this;
    }

    public ComptagenLigneBuilder setContrepartie(Compte contrepartie) {
        this.contrepartie = contrepartie;
        return this;
    }

    public ComptagenLigneBuilder setJournal(Journal journal) {
        this.journal = journal;
        return this;
    }

    public ComptagenLigneBuilder setNumeroCheque(int numeroCheque) {
        this.numerocheque = numeroCheque;
        return this;
    }

    public ComptagenLigneBuilder setModePaiement(String modePaiement) {
        this.modePaiement = modePaiement;
        return this;
    }

    public ComptagenLigneBuilder setFacture(String facture) {
        this.facture = facture;
        return this;
    }

    public ComptagenLigneBuilder setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
        return this;
    }

    public ComptagenLigneBuilder setMontant(boolean debit, long exportMoneyLong) {
        this.debit = debit;
        this.exportMoneyLong = exportMoneyLong;
        return this;
    }

    public ComptagenLigneBuilder setOriginalMontant(Amount originalAmount, Decimal conversionRate) {
        this.originalAmount = originalAmount;
        this.conversionRate = conversionRate;
        return this;
    }

    public ComptagenLigneBuilder clearOriginalMontant() {
        this.originalAmount = null;
        this.conversionRate = null;
        return this;
    }

    public ComptagenLigneBuilder inverse() {
        this.debit = !this.debit;
        return this;
    }

    public static ComptagenLigneBuilder init(String pieceRef, FuzzyDate date) {
        return new ComptagenLigneBuilder(pieceRef, date);
    }

    private class InternalComptagenLigne
    implements ComptagenLigne {
        private final int ecritureNum;
        private final String pieceRef;
        private final FuzzyDate date;
        private final int numerocheque;
        private final Compte compte;
        private final Compte compteTiers;
        private final Compte contrepartie;
        private final boolean debit;
        private final Journal journal;
        private final String modePaiement;
        private final long exportMoneyLong;
        private final Amount originalAmount;
        private final Decimal conversionRate;
        private final String libelle;
        private final String beneficiaireString;
        private final String facture;
        private final String shortTitle;

        private InternalComptagenLigne(int ecritureNum, String pieceRef, FuzzyDate date, Journal journal, Compte compte, Compte compteTiers, Compte contrepartie, String modePaiement, String libelle, String beneficiaireString, int numerocheque, boolean debit, long exportMoneyLong, Amount originalAmount, Decimal conversionRate, String facture, String shortTitle) {
            this.ecritureNum = ecritureNum;
            this.pieceRef = pieceRef;
            this.numerocheque = numerocheque;
            this.date = date;
            this.compte = compte;
            this.compteTiers = compteTiers;
            this.contrepartie = contrepartie;
            this.journal = journal;
            this.modePaiement = modePaiement;
            this.libelle = libelle;
            this.beneficiaireString = beneficiaireString;
            this.debit = debit;
            this.exportMoneyLong = exportMoneyLong;
            this.originalAmount = originalAmount;
            this.conversionRate = conversionRate;
            this.facture = facture;
            this.shortTitle = shortTitle;
        }

        @Override
        public int getEcritureNum() {
            return this.ecritureNum;
        }

        @Override
        public String getPieceRef() {
            return this.pieceRef;
        }

        @Override
        public FuzzyDate getDate() {
            return this.date;
        }

        @Override
        public Compte getCompte() {
            return this.compte;
        }

        @Override
        public Compte getCompteTiers() {
            return this.compteTiers;
        }

        @Override
        public Compte getContrepartie() {
            return this.contrepartie;
        }

        @Override
        public boolean isDebit() {
            return this.debit;
        }

        @Override
        public Journal getJournal() {
            return this.journal;
        }

        @Override
        public String getModePaiement() {
            return this.modePaiement;
        }

        @Override
        public int getNumerocheque() {
            return this.numerocheque;
        }

        @Override
        public long getExportMoneyLong() {
            return this.exportMoneyLong;
        }

        @Override
        public Amount getOriginalAmount() {
            return this.originalAmount;
        }

        @Override
        public Decimal getConversionRate() {
            return this.conversionRate;
        }

        @Override
        public String getLibelle() {
            return this.libelle;
        }

        @Override
        public String getBeneficiaireString() {
            return this.beneficiaireString;
        }

        @Override
        public String getFacture() {
            return this.facture;
        }

        @Override
        public String getShortTitle() {
            return this.shortTitle;
        }
    }
}

