/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatUnit;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetItem;

public class AgregatGatheringBuilder {
    private final MutableMoneyByCurrency mainMoneyByCurrency;
    private final int currencyLength;
    private final Map<SubsetItem, MutableMoneyByCurrency> unitMap = new HashMap<SubsetItem, MutableMoneyByCurrency>();

    public AgregatGatheringBuilder(int currencyLength) {
        this.mainMoneyByCurrency = new MutableMoneyByCurrency(currencyLength);
        this.currencyLength = currencyLength;
    }

    public void add(SubsetItem subsetItem, MoneyByCurrency moneyByCurrency) {
        this.mainMoneyByCurrency.add(moneyByCurrency);
        MutableMoneyByCurrency current = this.unitMap.get(subsetItem);
        if (current == null) {
            current = new MutableMoneyByCurrency(this.currencyLength);
            this.unitMap.put(subsetItem, current);
        }
        current.add(moneyByCurrency);
    }

    public AgregatGathering toAgregatGathering() {
        AgregatUnit[] unitArray = new AgregatUnit[this.unitMap.size()];
        int p = 0;
        for (Map.Entry<SubsetItem, MutableMoneyByCurrency> entry : this.unitMap.entrySet()) {
            unitArray[p] = AnalytiqueUtils.toAgregatUnit(entry.getKey(), entry.getValue().toUnmodifiableMoneyByCurrency());
            ++p;
        }
        List<AgregatUnit> agregatUnitList = AnalytiqueUtils.wrap(unitArray);
        MoneyByCurrency finalMoneyByCurrency = this.mainMoneyByCurrency.toUnmodifiableMoneyByCurrency();
        return new InternalAgregatGathering(finalMoneyByCurrency, agregatUnitList);
    }

    private static class InternalAgregatGathering
    implements AgregatGathering {
        private final MoneyByCurrency moneyByCurrency;
        private final List<AgregatUnit> agregatUnitList;

        private InternalAgregatGathering(MoneyByCurrency moneyByCurrency, List<AgregatUnit> agregatUnitList) {
            this.moneyByCurrency = moneyByCurrency;
            this.agregatUnitList = agregatUnitList;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }

        @Override
        public List<AgregatUnit> getUnitList() {
            return this.agregatUnitList;
        }
    }
}

