/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.ScarabeSpace;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDef;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDefManager;
import fr.exemole.bdfext.scarabe.api.core.LigneHolder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueItemEngine;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueSubsetBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.MotclePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SimpleMessageHandler;
import net.mapeadores.util.money.Currencies;

public class AnalytiqueEngine {
    private final AliasHolder coreAliasHolder;
    private final LigneHolder ligneHolder;
    private final Currencies currencies;
    private final PrerequestDefManager prerequestDefManager;

    public AnalytiqueEngine(AliasHolder coreAliasHolder, LigneHolder ligneHolder, Currencies currencies, PrerequestDefManager prerequestDefManager) {
        this.coreAliasHolder = coreAliasHolder;
        this.ligneHolder = ligneHolder;
        this.currencies = currencies;
        this.prerequestDefManager = prerequestDefManager;
    }

    public AnalytiqueSubset build(Subset subset) {
        SimpleMessageHandler simpleHandler = new SimpleMessageHandler();
        AnalytiqueDef analytiqueDef = AnalytiqueUtils.DEFAULT_ANALYTIQUEDEF;
        String xml = ScarabeSpace.getAnalytiqueDefXml(subset.getMetadata());
        if (!xml.isEmpty()) {
            analytiqueDef = AnalytiqueUtils.parseAnalytiqueDef(subset, xml, (MessageHandler)simpleHandler);
        }
        AnalytiqueSubsetBuilder builder = new AnalytiqueSubsetBuilder(subset, analytiqueDef, simpleHandler);
        for (PrerequestDef prerequestDef : this.prerequestDefManager.getPrerequestDefListBySubset(subset.getSubsetKey())) {
            builder.add(AnalytiqueUtils.toPrerequest(subset, prerequestDef));
        }
        if (subset instanceof Corpus) {
            this.initFromCorpus(builder, (Corpus)subset, analytiqueDef);
        } else if (subset instanceof Thesaurus) {
            this.initFromThesaurus(builder, (Thesaurus)subset, analytiqueDef);
        }
        return builder.toAnalytiqueSubset();
    }

    private void initFromCorpus(AnalytiqueSubsetBuilder builder, Corpus corpus, AnalytiqueDef analytiqueDef) {
        AnalytiqueItemEngine analytiqueItemEngine = new AnalytiqueItemEngine(this.coreAliasHolder, this.ligneHolder, this.currencies, analytiqueDef);
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)corpus);
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            AnalytiqueItem item = analytiqueItemEngine.build(fichePointeur);
            builder.add(item);
        }
    }

    private void initFromThesaurus(AnalytiqueSubsetBuilder builder, Thesaurus thesaurus, AnalytiqueDef analytiqueDef) {
        AnalytiqueItemEngine analytiqueItemEngine = new AnalytiqueItemEngine(this.coreAliasHolder, this.ligneHolder, this.currencies, analytiqueDef);
        MotclePointeur motclePointeur = PointeurFactory.newMotclePointeur((Thesaurus)thesaurus);
        for (Motcle motcle : thesaurus.getFirstLevelList()) {
            motclePointeur.setCurrentSubsetItem((SubsetItem)motcle);
            AnalytiqueItem item = analytiqueItemEngine.build(motclePointeur);
            builder.add(item);
        }
    }
}

