/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools;

import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;

public class MutableMoneyByCurrency
implements MoneyByCurrency {
    private final long[] totalArray;
    private final boolean[] withMoneyArray;

    public MutableMoneyByCurrency(int currencyLength) {
        this.totalArray = new long[currencyLength];
        this.withMoneyArray = new boolean[currencyLength];
    }

    public void add(int currencyIndex, long montant) {
        int n = currencyIndex;
        this.totalArray[n] = this.totalArray[n] + montant;
        this.withMoneyArray[currencyIndex] = true;
    }

    public void add(MoneyByCurrency moneyByCurrency) {
        int length = this.totalArray.length;
        for (int i = 0; i < length; ++i) {
            if (!moneyByCurrency.withMoney(i)) continue;
            int n = i;
            this.totalArray[n] = this.totalArray[n] + moneyByCurrency.getMoneyLong(i);
            this.withMoneyArray[i] = true;
        }
    }

    public void add(MoneyByCurrency moneyByCurrency, int sign) {
        if (sign < 0) {
            this.substract(moneyByCurrency);
        } else {
            this.add(moneyByCurrency);
        }
    }

    public void substract(MoneyByCurrency moneyByCurrency) {
        int length = this.totalArray.length;
        for (int i = 0; i < length; ++i) {
            if (!moneyByCurrency.withMoney(i)) continue;
            int n = i;
            this.totalArray[n] = this.totalArray[n] - moneyByCurrency.getMoneyLong(i);
            this.withMoneyArray[i] = true;
        }
    }

    @Override
    public boolean isEmpty() {
        int length = this.withMoneyArray.length;
        for (int i = 0; i < length; ++i) {
            if (!this.withMoneyArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getMoneyLong(int currencyIndex) {
        return this.totalArray[currencyIndex];
    }

    @Override
    public boolean withMoney(int currencyIndex) {
        return this.withMoneyArray[currencyIndex];
    }

    public MoneyByCurrency toUnmodifiableMoneyByCurrency() {
        boolean isEmpty = true;
        int length = this.withMoneyArray.length;
        long[] newMontantArray = new long[length];
        boolean[] newWithMontantArray = new boolean[length];
        for (int i = 0; i < length; ++i) {
            if (this.withMoneyArray[i]) {
                isEmpty = false;
            }
            newMontantArray[i] = this.totalArray[i];
            newWithMontantArray[i] = this.withMoneyArray[i];
        }
        return new InternalMoneyByCurrency(isEmpty, newMontantArray, newWithMontantArray);
    }

    private static class InternalMoneyByCurrency
    implements MoneyByCurrency {
        private final boolean empty;
        private final long[] moneyLongArray;
        private final boolean[] withMoneyArray;

        private InternalMoneyByCurrency(boolean empty, long[] moneyLongArray, boolean[] withMoneyArray) {
            this.empty = empty;
            this.moneyLongArray = moneyLongArray;
            this.withMoneyArray = withMoneyArray;
        }

        @Override
        public boolean isEmpty() {
            return this.empty;
        }

        @Override
        public boolean withMoney(int currencyIndex) {
            return this.withMoneyArray[currencyIndex];
        }

        @Override
        public long getMoneyLong(int currencyIndex) {
            return this.moneyLongArray[currencyIndex];
        }
    }
}

