/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html.ficheform;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FormElementProviderFactory;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusIncludeElementBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.pointeurs.FichePointeur;

public class SoldeFormElementProvider
implements FormElementProvider {
    private final FicheFormParameters ficheFormParameters;
    private final SoldeFicheFormParameters soldeParameters;
    private final Corpus avanceCorpus;
    private final Corpus depenseCorpus;
    private final FormElementProvider defaultProvider;

    private SoldeFormElementProvider(FicheFormParameters ficheFormParameters, SoldeFicheFormParameters soldeParameters) {
        this.ficheFormParameters = ficheFormParameters;
        this.soldeParameters = soldeParameters;
        this.avanceCorpus = soldeParameters.getAvanceCorpus();
        this.depenseCorpus = soldeParameters.getDepenseCorpus();
        this.defaultProvider = FormElementProviderFactory.newInstance((FicheFormParameters)ficheFormParameters);
    }

    public FormElement.Include getFormElement(FichePointeur fichePointeur, IncludeUi includeUi) {
        if (includeUi instanceof SubsetIncludeUi) {
            ExtendedIncludeKey includeKey = ((SubsetIncludeUi)includeUi).getExtendedIncludeKey();
            SubsetKey subsetKey = includeKey.getSubsetKey();
            if (subsetKey.equals((Object)this.avanceCorpus.getSubsetKey())) {
                if (!includeKey.hasPoidsFilter() || includeKey.getPoidsFilter() == 2) {
                    CorpusIncludeElementBuilder corpusIncludeElementBuilder = new CorpusIncludeElementBuilder(includeUi.getName(), this.avanceCorpus);
                    int poids = includeKey.getPoidsFilter() == 2 ? -1 : 2;
                    for (FicheMeta ficheMeta : this.soldeParameters.getAvanceList()) {
                        corpusIncludeElementBuilder.addFicheMeta(ficheMeta, poids);
                    }
                    return corpusIncludeElementBuilder.setHasPoidsFilter(includeKey.hasPoidsFilter()).populateOptions(this.ficheFormParameters, includeUi).toCorpusIncludeElement();
                }
            } else if (subsetKey.equals((Object)this.depenseCorpus.getSubsetKey()) && (!includeKey.hasPoidsFilter() || includeKey.getPoidsFilter() == 1)) {
                CorpusIncludeElementBuilder corpusIncludeElementBuilder = new CorpusIncludeElementBuilder(includeUi.getName(), this.depenseCorpus);
                int poids = includeKey.getPoidsFilter() == 1 ? -1 : 1;
                for (FicheMeta ficheMeta : this.soldeParameters.getDepenseList()) {
                    corpusIncludeElementBuilder.addFicheMeta(ficheMeta, poids);
                }
                return corpusIncludeElementBuilder.setHasPoidsFilter(includeKey.hasPoidsFilter()).populateOptions(this.ficheFormParameters, includeUi).toCorpusIncludeElement();
            }
        }
        return this.defaultProvider.getFormElement(fichePointeur, includeUi);
    }

    public FormElement.Field getFormElement(FichePointeur fichePointeur, FieldUi fieldUI) {
        return this.defaultProvider.getFormElement(fichePointeur, fieldUI);
    }

    public static SoldeFormElementProvider newInstance(FicheFormParameters ficheFormParameters, SoldeFicheFormParameters parameters) {
        if (parameters.isEmpty()) {
            return null;
        }
        return new SoldeFormElementProvider(ficheFormParameters, parameters);
    }

    public static class SoldeFicheFormParameters {
        private final List<FicheMeta> avanceList = new ArrayList<FicheMeta>();
        private final List<FicheMeta> depenseList = new ArrayList<FicheMeta>();
        private Corpus avanceCorpus;
        private Corpus depenseCorpus;

        public Corpus getAvanceCorpus() {
            return this.avanceCorpus;
        }

        public Corpus getDepenseCorpus() {
            return this.depenseCorpus;
        }

        public void setAvanceCorpus(Corpus avanceCorpus) {
            this.avanceCorpus = avanceCorpus;
        }

        public void setDepenseCorpus(Corpus depenseCorpus) {
            this.depenseCorpus = depenseCorpus;
        }

        public boolean addAvance(FicheMeta ficheMeta) {
            if (this.avanceList.contains(ficheMeta)) {
                return false;
            }
            this.avanceList.add(ficheMeta);
            return true;
        }

        public boolean addDepense(FicheMeta ficheMeta) {
            if (this.depenseList.contains(ficheMeta)) {
                return false;
            }
            this.depenseList.add(ficheMeta);
            return true;
        }

        public List<FicheMeta> getAvanceList() {
            return this.avanceList;
        }

        public List<FicheMeta> getDepenseList() {
            return this.depenseList;
        }

        public boolean isEmpty() {
            return this.avanceList.isEmpty() && this.depenseList.isEmpty();
        }
    }
}

