/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html.configuration;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.configuration.TableDefConfig;
import fr.exemole.bdfext.scarabe.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.MessageByLine;

public class ColumnsConfigHtmlProducer
extends BdfServerHtmlProducer {
    private final ScarabeContext scarabeContext;

    public ColumnsConfigHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.addExtensionThemeCss("scarabe", new String[]{"_action.css", "_family.css", "configuration.css"});
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
    }

    public void printHtml() {
        Recapitulatif recapitulatif = this.scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
        this.start();
        this.printCommandMessageUnit();
        this.printColDefForm("banque_general", "_ SCARABE-03", "_ title.scarabe.tabledef_general");
        List<AnalytiqueSubset> analytiqueSubsetList = recapitulatif.getAnalytiqueSubsetList();
        if (!analytiqueSubsetList.isEmpty()) {
            for (AnalytiqueSubset analytiqueSubset : analytiqueSubsetList) {
                Subset subset = analytiqueSubset.getSubset();
                this.printColDefForm(subset.getSubsetKeyString(), "_ SCARABE-04", subset);
            }
        }
        this.end();
    }

    private boolean printColDefForm(String tableDefName, String locKey, Object subtitle) {
        String content = ConfigurationUtils.getTableDefContent(this.scarabeContext, tableDefName);
        if (content == null) {
            content = "";
        }
        if (!content.contains("%")) {
            content = ColumnsConfigHtmlProducer.getDefaultContent(tableDefName) + "\n" + content;
        }
        CommandBox commandBox = CommandBox.init().action(Scarabe.DOMAIN).family("SCARABE").page("ColumnsConfig").name("TableDef").lockey(locKey).submitLocKey("_ submit.scarabe.tabledef").actionCssClass("action-scarabe-Columns").veil(true).helpUrl("").hidden("name", tableDefName);
        this.__start(commandBox);
        if (subtitle instanceof Subset) {
            this.H2().__escape((CharSequence)FichothequeUtils.getTitle((Subset)((Subset)subtitle), (Lang)this.workingLang))._H2();
        } else {
            this.H2().__localize(subtitle.toString())._H2();
        }
        TableDefConfig tableDefConfig = ConfigurationUtils.getTableDefConfig(this.scarabeContext, tableDefName);
        if (tableDefConfig != null && tableDefConfig.hasErrorsOrWarnings()) {
            this.UL();
            List<MessageByLine> list = tableDefConfig.getMessageByLineList();
            for (MessageByLine messageByLine : list) {
                this.LI().P().CODE().__append(messageByLine.getLineNumber())._CODE()._P().UL();
                for (MessageByLine.Category category : messageByLine.getCategoryList()) {
                    for (LineMessage message : category.getMessageList()) {
                        this.printMessageLi((Message)message);
                    }
                }
                this._UL()._LI();
            }
            this._UL();
        }
        this.TEXTAREA(HA.name((String)"content").cols(80).rows(15).attr("data-codemirror-mode", "tableexport")).__escape((CharSequence)content, true)._TEXTAREA().__end((Object)commandBox);
        return true;
    }

    private void printMessageLi(Message message) {
        this.LI().P().CODE().__escape((CharSequence)message.getMessageKey());
        Object[] values = message.getMessageValues();
        int length = values.length;
        if (length > 0) {
            this.__escape(": ");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    this.__escape(" / ");
                }
                this.__escape(values[i]);
            }
        }
        this._CODE()._P()._LI();
    }

    private static String getDefaultContent(String name) {
        String string;
        block9: {
            String resourceName = "default_analytique.txt";
            if (name.equals("banque_general")) {
                resourceName = "default_general.txt";
            }
            InputStream is = ColumnsConfigHtmlProducer.class.getResourceAsStream(resourceName);
            try {
                string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new InternalResourceException((Exception)ioe);
                }
            }
            is.close();
        }
        return string;
    }
}

