/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.BH;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.fiche.Montant;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.DateFormatBundle;

public class ResteWarningHtmlProducer
extends BdfServerHtmlProducer {
    private final ScarabeContext scarabeContext;
    private final DecimalFormatSymbols symbols;
    private final Recapitulatif recapitulatif;
    private final ScarabeLocalisation scarabeLocalisation;

    public ResteWarningHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.setBodyCssClass("global-body-ListFrame");
        this.symbols = new DecimalFormatSymbols(this.getFormatLocale());
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
        this.scarabeLocalisation = ScarabeLocalisation.build(bdfParameters);
    }

    public void printHtml() {
        this.start();
        ScarabeHtmlUtils.printRecapitulatifToolList((HtmlPrinter)this, Scarabe.DOMAIN);
        this.__((Consumer)PageUnit.start((Object)"_ title.scarabe.restewarning")).UL();
        HtmlAttributes linkAttr = HA.href((CharSequence)"").target("Edition");
        for (Mouvement mouvement : this.recapitulatif.getResteWarningMouvementList()) {
            this.printMouvementLi(linkAttr, mouvement);
        }
        this._UL().__(PageUnit.END);
        this.end();
    }

    private void printMouvementLi(HtmlAttributes linkAttr, Mouvement mouvement) {
        this.LI();
        FuzzyDate date = mouvement.getDate();
        DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle((Locale)this.getFormatLocale());
        this.P().__localize("_ label.scarabe.numeropiece").__colon().__append(mouvement.getNumeropiece()).__dash().__localize("_ label.scarabe.date").__colon().__escape((CharSequence)date.getDateLitteral(dateFormatBundle)).__dash().__localize("_ label.scarabe.libelle").__colon().__escape((CharSequence)mouvement.getLibelle())._P();
        this.UL();
        this.LI().P().__localize("_ label.scarabe.rappelmontant").__colon().__escape((CharSequence)MoneyUtils.toLitteralString((long)mouvement.getMontantMoneyLong(), (ExtendedCurrency)mouvement.getCurrency(), (DecimalFormatSymbols)this.symbols, (boolean)true)).__space().__escape('(').__localize(mouvement.isDebit() ? "_ label.scarabe.debit" : "_ label.scarabe.credit").__escape(')')._P()._LI();
        this.printFichesLiees(mouvement.getAvanceList(), "_ label.scarabe.fiche_avance");
        this.printFichesLiees(mouvement.getSoldeAvanceList(), "_ label.scarabe.fiche_avance_solde");
        this.printFichesLiees(mouvement.getDepenseList(), "_ label.scarabe.fiche_depense");
        this.printFichesLiees(mouvement.getApportList(), "_ label.scarabe.fiche_apport");
        this.LI().P().__localize("_ label.scarabe.reste").__colon().__escape((CharSequence)MoneyUtils.toLitteralString((long)mouvement.getResteMoneyLong(), (ExtendedCurrency)mouvement.getCurrency(), (DecimalFormatSymbols)this.symbols, (boolean)true))._P()._LI();
        this.LI().A(linkAttr.href((CharSequence)BH.domain((String)"edition").page("fiche-result").subsetItem((SubsetItem)mouvement.getFicheMeta()))).__localize("_ link.scarabe.mouvementresult")._A()._LI();
        this._UL();
        this._LI();
    }

    private void printFichesLiees(List<Ligne> ligneList, String messageKey) {
        for (Ligne ligne : ligneList) {
            Montant montant = ligne.getMontant();
            this.LI().P().EM().__localize(messageKey).__colon()._EM().__escape((CharSequence)ScarabeUtils.checkLibelle(ligne, this.scarabeLocalisation)).__colon().__escape((CharSequence)MoneyUtils.toLitteralString((Decimal)montant.getDecimal(), (ExtendedCurrency)montant.getCurrency(), (DecimalFormatSymbols)this.symbols))._P()._LI();
        }
    }
}

