/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.CustomLigneDef;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeDef;
import fr.exemole.bdfext.scarabe.html.consumers.DateInput;
import fr.exemole.bdfext.scarabe.html.consumers.OutputChoices;
import fr.exemole.bdfext.scarabe.html.consumers.TableaucroiseChoices;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfHref;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;

public class AnalytiqueRecapListHtmlProducer
extends BdfServerHtmlProducer {
    private static final Consumer<HtmlPrinter> TOTAUX_ROWFILTER_CHECK = Common.checkboxParagraph((String)"_ label.scarabe.totauxonly", (HtmlAttributes)HA.name((String)"filter").value("totaux"), (boolean)false);
    private static final Consumer<HtmlPrinter> WITHRECAP_CHECK = Common.checkboxParagraph((String)"_ label.scarabe.withrecap", (HtmlAttributes)HA.name((String)"withrecap").value("1"), (boolean)false);
    private static final Consumer<HtmlPrinter> DATE_INPUT = new DateInput("date");
    private static final Consumer<HtmlPrinter> DETAIL_SUBMIT = Button.submit((String)"_ submit.scarabe.analytiquedetail");
    private static final Consumer<HtmlPrinter> TABLEAUCROISE_SUBMIT = Button.submit((String)"_ link.scarabe.tableaucroise");
    private final DecimalFormatSymbols symbols;
    private final ScarabeContext scarabeContext;
    private final boolean ignoreEmpty;
    private final AnalytiqueRecap rootAnalytiqueRecap;
    private final AnalytiqueParameters analytiqueParameters;
    private final TableaucroiseChoices tableaucroiseChoices;
    private final OutputChoices detailOutputChoices;
    private final OutputChoices tableaucroiseOutputChoices;

    public AnalytiqueRecapListHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext, AnalytiqueRecap analytiqueRecap) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.analytiqueParameters = analytiqueRecap.getAnalytiqueParameters();
        short mode = this.analytiqueParameters.getMode();
        this.ignoreEmpty = mode == 1;
        this.rootAnalytiqueRecap = analytiqueRecap;
        this.symbols = new DecimalFormatSymbols(this.getFormatLocale());
        this.addExtensionThemeCss("scarabe", new String[]{"recap.css"});
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.setBodyCssClass("global-body-ListFrame");
        AnalytiqueDef analytiqueDef = this.analytiqueParameters.getAnalytiqueSubset().getAnalytiqueDef();
        this.tableaucroiseChoices = TableaucroiseChoices.build(analytiqueDef.getTableaucroiseDefList(), this.fichotheque, this.workingLang);
        this.detailOutputChoices = OutputChoices.build(BdfInstructionUtils.getPageOutput((String)"AnalytiqueDetailTable"), BdfInstructionUtils.getStreamOutput((String)"AnalytiqueDetailTable.ods"), (String)this.bdfUser.getParameterValue("scarabe.lastanalytiquedetailformat"));
        this.tableaucroiseOutputChoices = OutputChoices.build(BdfInstructionUtils.getPageOutput((String)"TableaucroiseTable"), BdfInstructionUtils.getStreamOutput((String)"TableaucroiseTable.ods"), (String)this.bdfUser.getParameterValue("scarabe.lasttableaucroiseformat"));
    }

    public void printHtml() {
        BdfHref href = BH.domain((String)Scarabe.DOMAIN).stream("AnalytiqueRecapList.ods").command("AnalytiqueRecap");
        AnalytiqueRecapListHtmlProducer.init(href, this.analytiqueParameters);
        this.start();
        this.DIV("tools-List").__((Consumer)ScarabeHtmlUtils.recapitulatifLink(Scarabe.DOMAIN)).__((Consumer)Button.link((String)href.toString()).action("action-Ods").textL10nObject((Object)"_ link.misc.ods_export"))._DIV();
        if (this.ignoreEmpty && this.rootAnalytiqueRecap.isEmpty()) {
            this.__(PageUnit.SIMPLE, () -> this.__(this.printSelectionWarning()).P().__localize("_ warning.scarabe.emptyforselection")._P());
        } else {
            if (this.analytiqueParameters.getMode() == 1) {
                this.__(PageUnit.SIMPLE, () -> this.printSelectionWarning());
            }
            if (this.rootAnalytiqueRecap.isRoot()) {
                this.printRoot();
            } else {
                this.printAnalytiqueRecap(this.rootAnalytiqueRecap, 0);
            }
        }
        this.end();
    }

    private boolean printSelectionWarning() {
        if (this.analytiqueParameters.getMode() == 1) {
            this.P("scarabe-recap-RappelSelection").__localize("_ warning.scarabe.currentselection")._P();
            return true;
        }
        return false;
    }

    private void printRoot() {
        if (this.ignoreEmpty && this.rootAnalytiqueRecap.isEmpty()) {
            return;
        }
        if (!this.analytiqueParameters.hideRootRecap()) {
            RecapState recapState = new RecapState();
            recapState.withLinks = true;
            this.DIV("unit-SimpleUnit").DIV().__(this.printRecapTable(this.rootAnalytiqueRecap, recapState)).__(this.printRecapLinks(null, recapState))._DIV()._DIV();
        }
        this.__(this.printSubRecapList(this.rootAnalytiqueRecap, 1));
    }

    private void printAnalytiqueRecap(AnalytiqueRecap analytiqueRecap, int level) {
        if (this.ignoreEmpty && analytiqueRecap.isEmpty()) {
            return;
        }
        boolean firstLevel = level == 1;
        Object recapObject = analytiqueRecap.getRecapObject();
        AnalytiqueItem analytiqueItem = null;
        RecapState recapState = new RecapState();
        String libelle = ScarabeUtils.getLibelle(recapObject, this.workingLang);
        if (firstLevel) {
            this.__((Consumer)PageUnit.startDetails((Object)new Litteral(libelle), (boolean)false));
        } else {
            this.P(this.getRecapClasses(recapObject, level)).__escape((CharSequence)libelle)._P();
        }
        if (recapObject instanceof AnalytiqueGathering) {
            AnalytiqueGathering ligneGathering = (AnalytiqueGathering)recapObject;
            if (ligneGathering.hasWarning()) {
                for (Message warningMessage : ligneGathering.getWarningList()) {
                    this.P().SPAN("scarabe-recap-Warning").__localize(warningMessage)._SPAN()._P();
                }
            }
            if (recapObject instanceof AnalytiqueItem) {
                analytiqueItem = (AnalytiqueItem)recapObject;
                recapState.withLinks = true;
            }
        }
        this.DIV(firstLevel ? "" : "scarabe-recap-DetailDiv").__(this.printRecapTable(analytiqueRecap, recapState)).__(this.printRecapLinks(analytiqueItem, recapState))._DIV();
        this.__(this.printSubRecapList(analytiqueRecap, level + 1));
        if (firstLevel) {
            this.__(PageUnit.END_DETAILS);
        }
    }

    private boolean printSubRecapList(AnalytiqueRecap analytiqueRecap, int level) {
        List<AnalytiqueRecap> subRecapList = analytiqueRecap.getSubRecapList();
        if (subRecapList.isEmpty()) {
            return false;
        }
        String soustotalClass = "";
        if (level > 2) {
            soustotalClass = "scarabe-recap-Soustotal";
        }
        this.DIV(soustotalClass);
        for (AnalytiqueRecap subRecap : subRecapList) {
            this.printAnalytiqueRecap(subRecap, level);
        }
        this._DIV();
        return true;
    }

    private boolean printRecapTable(AnalytiqueRecap analytiqueRecap, RecapState recapState) {
        Currencies currencies = analytiqueRecap.getCurrencies();
        this.TABLE("scarabe-recap-Table");
        for (Operation operation : analytiqueRecap.getOperationList()) {
            OperationDef operationDef = operation.getOperationDef();
            MoneyByCurrency moneyByCurrency = operation.getMoneyByCurrency();
            if (moneyByCurrency.isEmpty()) continue;
            this.TR();
            this.TD();
            if (!operationDef.getTitleLabels().isEmpty()) {
                this.__escape(operationDef.getTitle(this.workingLang)).__colon();
            } else if (operationDef instanceof SoldeDef) {
                this.__localize("_ label.scarabe.solde").__colon();
            } else if (operationDef instanceof CustomLigneDef) {
                this.__localize(AnalytiqueUtils.getLibelleKey(operationDef.getName())).__colon();
            } else {
                this.__escape(operationDef.getName()).__colon();
            }
            this._TD();
            this.printLigneRecap(moneyByCurrency, currencies);
            this._TR();
            if (!(operationDef instanceof CustomLigneDef)) continue;
            recapState.withDetail = true;
        }
        this._TABLE();
        return true;
    }

    private boolean printRecapLinks(AnalytiqueItem analytiqueItem, RecapState recapState) {
        if (!recapState.withLinks) {
            return false;
        }
        int id = -1;
        if (analytiqueItem != null) {
            id = analytiqueItem.getSubsetItem().getId();
        }
        if (recapState.withDetail) {
            this.DETAILS("scarabe-recap-Details").SUMMARY().__localize("_ link.scarabe.detail")._SUMMARY().DIV().FORM_get(Scarabe.DOMAIN, "Edition").INPUT_hidden((Map)AnalytiqueRecapListHtmlProducer.init("AnalytiqueDetail", this.analytiqueParameters, id)).__(DATE_INPUT).__(TOTAUX_ROWFILTER_CHECK).__(WITHRECAP_CHECK).__((Consumer)this.detailOutputChoices).__(DETAIL_SUBMIT)._FORM()._DIV()._DETAILS();
        }
        if (!this.tableaucroiseChoices.isEmpty()) {
            this.DETAILS("scarabe-recap-Details").SUMMARY().__localize("_ title.scarabe.tableaucroise")._SUMMARY().DIV().FORM_get(Scarabe.DOMAIN, "Edition").INPUT_hidden((Map)AnalytiqueRecapListHtmlProducer.init("AnalytiqueDetail", this.analytiqueParameters, id)).__((Consumer)this.tableaucroiseChoices).__(DATE_INPUT).__((Consumer)this.tableaucroiseOutputChoices).__(TABLEAUCROISE_SUBMIT)._FORM()._DIV()._DETAILS();
        }
        return true;
    }

    private static ParameterMap init(String commandName, AnalytiqueParameters analytiqueParameters, int id) {
        ExtendedCurrency currency;
        ParameterMap parameterMap = ParameterMap.init().command(commandName).param("subset", analytiqueParameters.getAnalytiqueSubset().getSubsetKey().getKeyString()).borderFrameStyle();
        if (analytiqueParameters.getMode() == 1) {
            parameterMap.param("selection", "1");
        }
        if ((currency = analytiqueParameters.getConversionCurrency()) != null) {
            parameterMap.param("conversion", currency.getCurrencyCode());
        }
        AnalytiqueRecapListHtmlProducer.addIdSet(parameterMap, "include", analytiqueParameters.getIncludeIdSet());
        AnalytiqueRecapListHtmlProducer.addIdSet(parameterMap, "exclude", analytiqueParameters.getExcludeIdSet());
        if (id > 0) {
            parameterMap.param("id", String.valueOf(id));
        }
        return parameterMap;
    }

    private static void addIdSet(ParameterMap parameterMap, String paramName, Set<Integer> idSet) {
        if (idSet.isEmpty()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (Integer itg : idSet) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(itg);
        }
        parameterMap.param(paramName, buf.toString());
    }

    private void printLigneRecap(MoneyByCurrency recapMoneyByCurrency, Currencies currencies) {
        this.TD("scarabe-recap-Montant");
        int length = currencies.size();
        boolean next = false;
        for (int i = 0; i < length; ++i) {
            if (!recapMoneyByCurrency.withMoney(i)) continue;
            if (next) {
                this.BR();
            } else {
                next = true;
            }
            this.__escape(MoneyUtils.toLitteralString((long)recapMoneyByCurrency.getMoneyLong(i), (ExtendedCurrency)((ExtendedCurrency)currencies.get(i)), (DecimalFormatSymbols)this.symbols, (boolean)false));
        }
        this._TD();
    }

    private static void init(BdfHref href, AnalytiqueParameters analytiqueParameters) {
        Set<Integer> excludeSet;
        Set<Integer> includeSet;
        ExtendedCurrency conversionCurrency;
        href.param("subset", analytiqueParameters.getAnalytiqueSubset().getSubsetKey().getKeyString());
        short mode = analytiqueParameters.getMode();
        if (mode == 1) {
            href.param("selection", "1");
        }
        if ((conversionCurrency = analytiqueParameters.getConversionCurrency()) != null) {
            href.param("conversion", conversionCurrency.getCurrencyCode());
        }
        if (!(includeSet = analytiqueParameters.getIncludeIdSet()).isEmpty()) {
            href.param("include", AnalytiqueRecapListHtmlProducer.toString(includeSet));
        }
        if (!(excludeSet = analytiqueParameters.getExcludeIdSet()).isEmpty()) {
            href.param("exclude", AnalytiqueRecapListHtmlProducer.toString(excludeSet));
        }
        if (analytiqueParameters.hideRootRecap()) {
            href.param("hide_root", "1");
        }
    }

    private static String toString(Set<Integer> idSet) {
        if (idSet.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Integer itg : idSet) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(itg);
        }
        return buf.toString();
    }

    private String getRecapClasses(Object recapObject, int level) {
        String recapClasses = "";
        if (recapObject instanceof AnalytiqueItem) {
            recapClasses = "scarabe-recap-AnalytiqueItem scarabe-recap-AnalytiqueItem_" + level;
        } else if (recapObject instanceof AnalytiqueGathering.Groupby) {
            recapClasses = "scarabe-recap-Groupby";
        } else if (recapObject instanceof AnalytiqueGathering.SubCorpus) {
            recapClasses = "scarabe-recap-SubCorpus";
        }
        return recapClasses;
    }

    private static class RecapState {
        boolean withDetail = false;
        boolean withLinks = false;

        private RecapState() {
        }
    }
}

