/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDef;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDefManager;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.List;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SimpleMessageHandler;
import net.mapeadores.util.request.RequestMap;

public class PrerequestConfigCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "PrerequestConfig";
    public static final String COMMANDKEY = "_ SCARABE-05";
    public static final String XML = "xml";
    private final ScarabeContext scarabeContext;
    private List<PrerequestDef> prerequestDefList;

    public PrerequestConfigCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin(Scarabe.DOMAIN, COMMANDNAME);
        PrerequestDefManager prerequestDefManager = ConfigurationUtils.getPrerequestDefManager(this.scarabeContext);
        prerequestDefManager.update(this.prerequestDefList);
        ConfigurationUtils.savePrerequestDefManager(this.scarabeContext, editOrigin);
        this.setDone("_ done.scarabe.prerequestconfig", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        List list;
        this.checkFichothequeAdmin();
        ScarabeUtils.checkInitState(this.scarabeContext);
        String xmlContent = this.getMandatory(XML);
        SimpleMessageHandler simpleHandler = new SimpleMessageHandler();
        this.prerequestDefList = AnalytiqueUtils.parsePrerequestDefList(xmlContent, (MessageHandler)simpleHandler);
        if (simpleHandler.hasMessage() && !(list = simpleHandler.filterSevere()).isEmpty()) {
            Message message = (Message)list.get(0);
            throw BdfErrors.error((String)message.getMessageKey(), (Object[])message.getMessageValues());
        }
    }
}

