/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.api.core;

import java.util.HashMap;
import java.util.Map;

public final class LigneKey {
    private static final Map<String, LigneKey> internMap = new HashMap<String, LigneKey>();
    private final String keyString;
    private final String alias;
    private final int id;
    private final boolean soldeAvance;

    private LigneKey(String keyString, String alias, int id, boolean soldeAvance) {
        this.keyString = keyString;
        this.alias = alias;
        this.id = id;
        this.soldeAvance = soldeAvance;
        LigneKey.intern(this);
    }

    public String getAlias() {
        return this.alias;
    }

    public int getId() {
        return this.id;
    }

    public boolean isSoldeAvance() {
        return this.soldeAvance;
    }

    public int hashCode() {
        return this.keyString.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        LigneKey otherLigneKey = (LigneKey)other;
        return otherLigneKey.keyString.equals(this.keyString);
    }

    public String toString() {
        return this.keyString;
    }

    private static synchronized void intern(LigneKey ligneKey) {
        internMap.put(ligneKey.keyString, ligneKey);
    }

    public static LigneKey get(String alias, int id) {
        return LigneKey.get(alias, id, false);
    }

    public static LigneKey get(String alias, int id, boolean soldeAvance) {
        String key = soldeAvance && alias.equals("avance") ? alias + "_" + id + "_f" : alias + "_" + id;
        LigneKey current = internMap.get(key);
        if (current != null) {
            return current;
        }
        return new LigneKey(key, alias, id, soldeAvance);
    }
}

