/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfext.scarabe.tools.cours.CoursManagerBuilder;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.format.formatters.MotcleFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyConversion;
import net.mapeadores.util.money.MoneyLong;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;

public class ScarabeInstructionResolverProvider
implements InstructionResolverProvider {
    private final ScarabeContext scarabeContext;
    private final Fichotheque fichotheque;

    public ScarabeInstructionResolverProvider(ScarabeContext scarabeContext, Fichotheque fichotheque) {
        this.scarabeContext = scarabeContext;
        this.fichotheque = fichotheque;
    }

    public InstructionResolver getInstructionResolver(Class destinationClass, Object optionObject) {
        if (this.scarabeContext.getInitState() != 1) {
            return null;
        }
        if (destinationClass.equals(FicheItemFormatter.class)) {
            return new FicheItemInstructionResolver();
        }
        if (destinationClass.equals(MotcleFormatter.class)) {
            return new MotcleFormatterFactory();
        }
        return null;
    }

    private class FicheItemInstructionResolver
    implements InstructionResolver {
        private FicheItemInstructionResolver() {
        }

        public Object resolve(Instruction instruction) throws ErrorMessageException {
            Argument arg1 = (Argument)instruction.get(0);
            String key = arg1.getKey();
            if (key.equals("scarabe_montant_pivot")) {
                return this.newInstance(arg1, true);
            }
            if (key.equals("scarabe_moneylong_pivot")) {
                return this.newInstance(arg1, false);
            }
            return null;
        }

        private PivotFicheItemFormatter newInstance(Argument arg1, boolean decimal) throws ErrorMessageException {
            String key = arg1.getKey();
            AliasHolder coreAliasHolder = ScarabeInstructionResolverProvider.this.scarabeContext.getCoreAliasHolder();
            AliasHolder coursAliasHolder = ScarabeInstructionResolverProvider.this.scarabeContext.getCoursAliasHolder();
            if (coursAliasHolder == null) {
                throw new ErrorMessageException("_ error.unsupported.scarabe.coursalias");
            }
            String val = arg1.getValue();
            if (val == null) {
                throw new ErrorMessageException("_ error.empty.argumentvalue", new Object[]{key});
            }
            try {
                ExtendedCurrency currency = ExtendedCurrency.parse((String)val);
                CoursManager coursManager = CoursManagerBuilder.build(coursAliasHolder);
                return new PivotFicheItemFormatter(coreAliasHolder, coursManager, currency, decimal);
            }
            catch (ParseException pe) {
                throw new ErrorMessageException("_ error.wrong.currency", new Object[]{val});
            }
        }
    }

    private class MotcleFormatterFactory
    implements InstructionResolver {
        private MotcleFormatterFactory() {
        }

        public Object resolve(Instruction instruction) throws ErrorMessageException {
            Argument arg1 = (Argument)instruction.get(0);
            String key = arg1.getKey();
            if (key.equals("scarabe_correspondance_id")) {
                String val = arg1.getValue();
                if (val == null) {
                    throw new ErrorMessageException("_ error.empty.argumentvalue", new Object[]{key});
                }
                try {
                    SubsetKey thesaurusKey = SubsetKey.parse((String)val);
                    if (!thesaurusKey.isThesaurusSubset()) {
                        throw new ErrorMessageException("_ error.wrong.argumentvalue", new Object[]{key, val});
                    }
                    Thesaurus thesaurus = (Thesaurus)ScarabeInstructionResolverProvider.this.fichotheque.getSubset(thesaurusKey);
                    if (thesaurus == null) {
                        throw new ErrorMessageException("_ error.unknown.thesaurus", new Object[]{thesaurusKey.getKeyString()});
                    }
                    return new CorrespondanceIdFormatter(thesaurus);
                }
                catch (ParseException pe) {
                    throw new ErrorMessageException("_ error.wrong.argumentvalue", new Object[]{key, val});
                }
            }
            return null;
        }
    }

    private static class CorrespondanceIdFormatter
    implements MotcleFormatter {
        private final Thesaurus destinationThesaurus;

        private CorrespondanceIdFormatter(Thesaurus destinationThesaurus) {
            this.destinationThesaurus = destinationThesaurus;
        }

        public String formatMotcle(Motcle motcle, int poids, FormatSource formatSource) {
            String idalpha = motcle.getIdalpha();
            if (idalpha == null || idalpha.length() < 1) {
                return null;
            }
            String idalpha2 = idalpha.substring(0, idalpha.length() - 1);
            Motcle motcle2 = this.destinationThesaurus.getMotcleByIdalpha(idalpha2);
            if (motcle2 == null) {
                return null;
            }
            return String.valueOf(motcle2.getId());
        }
    }

    private static class PivotFicheItemFormatter
    implements FicheItemFormatter {
        private final ExtendedCurrency pivotCurrency;
        private final AliasHolder coreAliasHolder;
        private final CoursManager coursManager;
        private final boolean decimal;

        private PivotFicheItemFormatter(AliasHolder coreAliasHolder, CoursManager coursManager, ExtendedCurrency pivotCurrency, boolean decimal) {
            this.pivotCurrency = pivotCurrency;
            this.coreAliasHolder = coreAliasHolder;
            this.coursManager = coursManager;
            this.decimal = decimal;
        }

        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof Montant)) {
                return "";
            }
            Montant montant = (Montant)ficheItem;
            ExtendedCurrency otherCurrency = montant.getCurrency();
            FuzzyDate date = this.getDate(formatSource);
            long otherMoneyLong = montant.toMoneyLong();
            MoneyConversion moneyConversion = this.coursManager.getMoneyConversion(date, this.pivotCurrency, otherCurrency);
            if (moneyConversion == null) {
                return "";
            }
            long pivotMoneyLong = moneyConversion.convertToPivot(otherMoneyLong);
            if (this.decimal) {
                int fractionDigits = this.pivotCurrency.getDefaultFractionDigits();
                Decimal pivotDecimal = MoneyLong.toDecimal((long)pivotMoneyLong, (int)fractionDigits, (boolean)false);
                return pivotDecimal.toString();
            }
            return String.valueOf(pivotMoneyLong);
        }

        private FuzzyDate getDate(FormatSource formatSource) {
            SubsetItemPointeur subsetItemPointeur = formatSource.getSubsetItemPointeur();
            if (!(subsetItemPointeur instanceof FichePointeur)) {
                return null;
            }
            FichePointeur fichePointeur = (FichePointeur)subsetItemPointeur;
            Corpus corpus = fichePointeur.getCorpus();
            String alias = CoreUtils.getCorpusAlias(this.coreAliasHolder, corpus);
            if (alias == null) {
                return null;
            }
            CorpusField dateField = CoreUtils.getDate(this.coreAliasHolder, alias);
            if (dateField == null) {
                return null;
            }
            Object obj = fichePointeur.getValue(dateField);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Datation)) {
                return null;
            }
            return ((Datation)obj).getDate();
        }
    }
}

