/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.ScarabeActionProvider;
import fr.exemole.bdfext.scarabe.ScarabeBdfCommandProvider;
import fr.exemole.bdfext.scarabe.ScarabeBdfHtmlHookProvider;
import fr.exemole.bdfext.scarabe.ScarabeBdfInstructionProvider;
import fr.exemole.bdfext.scarabe.ScarabeCache;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeHtmlProducerProvider;
import fr.exemole.bdfext.scarabe.ScarabeInstructionResolverProvider;
import fr.exemole.bdfext.scarabe.ScarabeJsLibProvider;
import fr.exemole.bdfext.scarabe.ScarabeJsonProducerProvider;
import fr.exemole.bdfext.scarabe.ScarabeMenuLinkProvider;
import fr.exemole.bdfext.scarabe.ScarabeStreamProducerProvider;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.tools.RecapitulatifBuilder;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenUtils;
import fr.exemole.bdfext.scarabe.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfext.scarabe.tools.cours.CoursUtils;
import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSessionListener;
import fr.exemole.bdfserver.api.providers.ActionProvider;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import fr.exemole.bdfserver.api.providers.BdfInstructionProvider;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import fr.exemole.bdfserver.api.providers.JsonProducerProvider;
import fr.exemole.bdfserver.api.providers.MenuLinkProvider;
import fr.exemole.bdfserver.api.providers.StreamProducerProvider;
import fr.exemole.bdfserver.api.storage.BdfExtensionStorage;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.EditableResourceStorage;
import fr.exemole.bdfserver.html.BdfHtmlHookProvider;
import fr.exemole.bdfserver.html.JsLibProvider;
import fr.exemole.bdfserver.tools.storage.DirectoryEditableResourceStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.alias.AliasChecker;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.tools.alias.AliasDOMReader;
import net.fichotheque.tools.alias.AliasHolderBuilder;
import net.fichotheque.tools.alias.AliasUtils;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.MessageLog;
import net.mapeadores.util.logging.MessageLogBuilder;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;

public class ScarabeBdfExtensionInitializer
implements BdfExtensionInitializer {
    public String getRegistrationName() {
        return "scarabe";
    }

    public BdfExtensionInitializer.Factory init(BdfExtensionStorage bdfExtensionStorage, Fichotheque fichotheque) {
        File oldBackupDirectory;
        File backupDirectory;
        File oldDataDirectory;
        File dataDirectory = bdfExtensionStorage.getDataDirectory("scarabe");
        if (!dataDirectory.exists() && (oldDataDirectory = bdfExtensionStorage.getDataDirectory("fr-exemole-scarabe")).exists()) {
            oldDataDirectory.renameTo(dataDirectory);
        }
        if ((backupDirectory = bdfExtensionStorage.getBackupDirectory("scarabe")) != null && !backupDirectory.exists() && (oldBackupDirectory = bdfExtensionStorage.getBackupDirectory("fr-exemole-scarabe")).exists()) {
            oldBackupDirectory.renameTo(backupDirectory);
        }
        DirectoryEditableResourceStorage dataStorage = new DirectoryEditableResourceStorage("scarabe", dataDirectory, backupDirectory);
        InternalScarabeContext scarabeContextImpl = new InternalScarabeContext(fichotheque, (EditableResourceStorage)dataStorage);
        scarabeContextImpl.reinit();
        return new InternalFactory(scarabeContextImpl, fichotheque);
    }

    private static AliasHolder initAliasHolder(Fichotheque fichotheque, String resourceName, AliasChecker aliasChecker, AliasHolder coreAliasHolder, MultiMessageHandler multiMessageHandler) {
        AliasHolder aliasHolder;
        multiMessageHandler.setCurrentSource(resourceName);
        AliasUtils.ErrorHandler aliasHandler = new AliasUtils.ErrorHandler((MessageHandler)multiMessageHandler);
        try (InputStream is = ScarabeBdfExtensionInitializer.class.getResourceAsStream("tools/defaultfiles/" + resourceName);){
            Document document = DOMUtils.readDocument((InputStream)is);
            AliasHolderBuilder builder = new AliasHolderBuilder(fichotheque, (MessageHandler)aliasHandler, aliasChecker, coreAliasHolder);
            AliasDOMReader reader = new AliasDOMReader(builder);
            reader.readAlias(document.getDocumentElement());
            aliasHolder = builder.toAliasHolder();
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        if (aliasHandler.isWithError()) {
            return null;
        }
        return aliasHolder;
    }

    private static class InternalScarabeContext
    implements ScarabeContext {
        private final Fichotheque fichotheque;
        private final EditableResourceStorage dataStorage;
        private final Map<String, Object> contextObjectMap = new HashMap<String, Object>();
        private final InternalScarabeCache scarabeCache = new InternalScarabeCache();
        private final EditSessionListener editSessionListener = new InternalEditSessionListener();
        private AliasHolder coreAliasHolder;
        private AliasHolder coursAliasHolder;
        private AliasHolder comptagenAliasHolder;
        private short initState = (short)2;
        private MessageLog initMessageLog = LogUtils.EMPTY_MESSAGELOG;

        private InternalScarabeContext(Fichotheque fichotheque, EditableResourceStorage dataStorage) {
            this.fichotheque = fichotheque;
            this.dataStorage = dataStorage;
        }

        @Override
        public short getInitState() {
            return this.initState;
        }

        @Override
        public MessageLog getInitMessageLog() {
            return this.initMessageLog;
        }

        @Override
        public ScarabeCache getScarabeCache() {
            return this.scarabeCache;
        }

        @Override
        public AliasHolder getCoreAliasHolder() {
            return this.coreAliasHolder;
        }

        @Override
        public AliasHolder getCoursAliasHolder() {
            return this.coursAliasHolder;
        }

        @Override
        public AliasHolder getComptagenAliasHolder() {
            return this.comptagenAliasHolder;
        }

        @Override
        public EditableResourceStorage getDataStorage() {
            return this.dataStorage;
        }

        @Override
        public Object getContextObject(String objectName) {
            return this.contextObjectMap.get(objectName);
        }

        @Override
        public synchronized void putContextObject(String objectName, Object object) {
            this.contextObjectMap.put(objectName, object);
        }

        @Override
        public void reinit() {
            this.coreAliasHolder = null;
            this.comptagenAliasHolder = null;
            this.coursAliasHolder = null;
            RelativePath path = RelativePath.build((String)"conf/version.ini");
            MessageLogBuilder logBuilder = new MessageLogBuilder();
            if (!this.dataStorage.containsResource(path)) {
                this.testMissingVersion(path, (MultiMessageHandler)logBuilder);
            } else {
                DocStream docStream = this.dataStorage.getResourceDocStream(path);
                HashMap paramMap = new HashMap();
                try (InputStream is = docStream.getInputStream();){
                    IniParser.parseIni((InputStream)is, paramMap);
                }
                catch (IOException ioe) {
                    throw new BdfStorageException((Throwable)ioe);
                }
                String version = (String)paramMap.get("version");
                if (version == null || !version.equals("1")) {
                    this.initState = (short)3;
                } else {
                    this.coreAliasHolder = ScarabeBdfExtensionInitializer.initAliasHolder(this.fichotheque, "scarabe-alias-core.xml", CoreUtils.CORE_ALIASCHECKER, null, (MultiMessageHandler)logBuilder);
                    if (this.coreAliasHolder == null) {
                        this.initState = (short)4;
                    } else {
                        this.initState = 1;
                        this.coursAliasHolder = ScarabeBdfExtensionInitializer.initAliasHolder(this.fichotheque, "scarabe-alias-cours.xml", CoursUtils.COURS_ALIASCHECKER, this.coreAliasHolder, (MultiMessageHandler)logBuilder);
                        this.comptagenAliasHolder = ScarabeBdfExtensionInitializer.initAliasHolder(this.fichotheque, "scarabe-alias-comptagen.xml", ComptagenUtils.COMPTAGEN_ALIASCHECKER, this.coreAliasHolder, (MultiMessageHandler)logBuilder);
                    }
                }
            }
            this.initMessageLog = logBuilder.toMessageLog();
            this.contextObjectMap.clear();
            ConfigurationUtils.initTableDefConfig(this);
            ConfigurationUtils.initPrerequestDefManager(this);
        }

        private void testMissingVersion(RelativePath path, MultiMessageHandler multiMessageHandler) {
            this.coreAliasHolder = ScarabeBdfExtensionInitializer.initAliasHolder(this.fichotheque, "scarabe-alias-core.xml", CoreUtils.CORE_ALIASCHECKER, null, multiMessageHandler);
            if (this.coreAliasHolder == null) {
                this.initState = (short)2;
            } else {
                this.initState = 1;
                this.coursAliasHolder = ScarabeBdfExtensionInitializer.initAliasHolder(this.fichotheque, "scarabe-alias-cours.xml", CoursUtils.COURS_ALIASCHECKER, this.coreAliasHolder, multiMessageHandler);
                this.comptagenAliasHolder = ScarabeBdfExtensionInitializer.initAliasHolder(this.fichotheque, "scarabe-alias-comptagen.xml", ComptagenUtils.COMPTAGEN_ALIASCHECKER, this.coreAliasHolder, multiMessageHandler);
                String text = "version = 1";
                try {
                    byte[] byteArray = text.getBytes("UTF-8");
                    this.dataStorage.saveResource(path, (InputStream)new ByteArrayInputStream(byteArray), EditOriginUtils.newEditOrigin((String)"init"));
                }
                catch (IOException ioe) {
                    throw new BdfStorageException((Throwable)ioe);
                }
            }
        }

        private class InternalScarabeCache
        implements ScarabeCache {
            private Recapitulatif recapitulatif;

            private InternalScarabeCache() {
            }

            @Override
            public synchronized Recapitulatif getRecapitulatif(BdfServer bdfServer) {
                if (this.recapitulatif == null) {
                    this.recapitulatif = RecapitulatifBuilder.recapitule(bdfServer, InternalScarabeContext.this);
                }
                return this.recapitulatif;
            }

            private synchronized void clearRecapitulatif() {
                this.recapitulatif = null;
            }
        }

        private class InternalEditSessionListener
        implements EditSessionListener {
            private InternalEditSessionListener() {
            }

            public void useOfFichothequeEditor() {
                InternalScarabeContext.this.scarabeCache.clearRecapitulatif();
            }
        }
    }

    private static class InternalFactory
    implements BdfExtensionInitializer.Factory {
        private final ScarabeContext scarabeContext;
        private final Fichotheque fichotheque;

        private InternalFactory(ScarabeContext scarabeContext, Fichotheque fichotheque) {
            this.scarabeContext = scarabeContext;
            this.fichotheque = fichotheque;
        }

        public Object getImplementation(BdfServer bdfServer, Class interfaceClass) {
            if (interfaceClass.equals(HtmlProducerProvider.class)) {
                return new ScarabeHtmlProducerProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(StreamProducerProvider.class)) {
                return new ScarabeStreamProducerProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(JsonProducerProvider.class)) {
                return new ScarabeJsonProducerProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(BdfCommandProvider.class)) {
                return new ScarabeBdfCommandProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(ActionProvider.class)) {
                return new ScarabeActionProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(MenuLinkProvider.class)) {
                return new ScarabeMenuLinkProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(BdfInstructionProvider.class)) {
                return new ScarabeBdfInstructionProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(InstructionResolverProvider.class)) {
                return new ScarabeInstructionResolverProvider(this.scarabeContext, this.fichotheque);
            }
            if (interfaceClass.equals(EditSessionListener.class)) {
                return ((InternalScarabeContext)this.scarabeContext).editSessionListener;
            }
            if (interfaceClass.equals(Message.class)) {
                return LocalisationUtils.toMessage((String)"_ title.scarabe.extension");
            }
            if (interfaceClass.equals(BdfHtmlHookProvider.class)) {
                return new ScarabeBdfHtmlHookProvider(this.scarabeContext);
            }
            if (interfaceClass.equals(JsLibProvider.class)) {
                return new ScarabeJsLibProvider();
            }
            return null;
        }
    }
}

