/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.memento;

import fr.exemole.bdfext.resourcesupdate.tools.memento.Destination;
import fr.exemole.bdfext.resourcesupdate.tools.memento.MementoMotcle;
import fr.exemole.bdfext.resourcesupdate.tools.memento.ThesaurusToMemento;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.extraction.builders.ExtractParametersBuilder;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.xml.extraction.FicheBlockXMLPart;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class Unit
extends MementoMotcle {
    private final Destination destination;
    private final List<MementoMotcle> mementoMotcleList;
    private final Langs availableLangs;
    private final ThesaurusToMemento mementoEngine;

    public Unit(Motcle motcle, Destination destination, ThesaurusToMemento mementoEngine) {
        super(motcle);
        this.destination = destination;
        this.availableLangs = Unit.getLangs(motcle);
        this.mementoMotcleList = this.init(motcle);
        this.mementoEngine = mementoEngine;
    }

    public String getTreePath() {
        return this.destination.getCompletPath(this.getName() + "/tree.xml");
    }

    public String getL10nPath(MementoMotcle mementoMotcle, Lang lang) {
        return this.destination.getCompletPath(this.getName() + "/" + lang.toString() + "/" + mementoMotcle.getName() + ".xml");
    }

    public Langs getAvailableLangs() {
        return this.availableLangs;
    }

    public void writeTreeXmlFile(AppendableXMLWriter xmlWriter) throws IOException {
        xmlWriter.appendXMLDeclaration();
        TreeXMLPart treeXMLPart = new TreeXMLPart((XMLWriter)xmlWriter);
        treeXMLPart.appendTree(this.getMotcle());
    }

    public void writeNodeXmlFile(AppendableXMLWriter xmlWriter, MementoMotcle mementoMotcle, Lang lang, ExtractionContext extractionContext) throws IOException {
        Motcle nodeMotcle = mementoMotcle.getMotcle();
        String title = nodeMotcle.getLabels().getLabel(lang).getLabelString();
        xmlWriter.appendXMLDeclaration();
        NodeXMLPart treeXMLPart = new NodeXMLPart((XMLWriter)xmlWriter, extractionContext);
        treeXMLPart.appendNode(title, (FicheBlocks)this.mementoEngine.getSection(lang, nodeMotcle));
    }

    public List<MementoMotcle> getMementoMotcleList() {
        return this.mementoMotcleList;
    }

    private List<MementoMotcle> init(Motcle motcle) {
        ArrayList<MementoMotcle> result = new ArrayList<MementoMotcle>();
        result.add(this);
        for (Motcle child : motcle.getChildList()) {
            this.add(result, child);
        }
        return result;
    }

    private void add(List<MementoMotcle> list, Motcle motcle) {
        list.add(new MementoMotcle(motcle));
        for (Motcle child : motcle.getChildList()) {
            this.add(list, child);
        }
    }

    private static Langs getLangs(Motcle motcle) {
        Labels labels = motcle.getLabels();
        Lang[] langArray = new Lang[labels.size()];
        int p = 0;
        for (Label label : labels) {
            langArray[p] = label.getLang();
        }
        return LangsUtils.wrap((Lang[])langArray);
    }

    private static class TreeXMLPart
    extends XMLPart {
        private TreeXMLPart(XMLWriter xmlWriter) {
            super(xmlWriter);
        }

        private void appendTree(Motcle motcle) throws IOException {
            this.startOpenTag("tree");
            this.addAttribute("name", motcle.getIdalpha());
            this.endOpenTag();
            for (Motcle child : motcle.getChildList()) {
                this.appendNode(child);
            }
            this.closeTag("tree");
        }

        private void appendNode(Motcle motcle) throws IOException {
            List childList = motcle.getChildList();
            if (childList.isEmpty()) {
                this.startOpenTag("leaf");
                this.addAttribute("name", motcle.getIdalpha());
                this.closeEmptyTag();
            } else {
                this.startOpenTag("branch");
                this.addAttribute("name", motcle.getIdalpha());
                this.endOpenTag();
                for (Motcle child : childList) {
                    this.appendNode(child);
                }
                this.closeTag("branch");
            }
        }
    }

    private static class NodeXMLPart
    extends XMLPart {
        private final FicheBlockXMLPart ficheBlockXMLPart;

        public NodeXMLPart(XMLWriter xmlWriter, ExtractionContext extractionContext) {
            super(xmlWriter);
            ExtractParameters extractParameters = ExtractParametersBuilder.init((ExtractionContext)extractionContext).setExtractVersion(2).setWithEmpty(false).toExtractParameters();
            this.ficheBlockXMLPart = new FicheBlockXMLPart((XMLWriter)this, extractParameters);
        }

        public void appendNode(String title, FicheBlocks ficheBlocks) throws IOException {
            this.openTag("node");
            this.addSimpleElement("title", title);
            if (ficheBlocks != null) {
                this.openTag("section");
                this.ficheBlockXMLPart.addFicheBlocks(ficheBlocks, ExtractionUtils.SAME_CONVERTER);
                this.closeTag("section");
            }
            this.closeTag("node");
        }
    }
}

