/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate;

import fr.exemole.bdfext.resourcesupdate.ResourcesUpdate;
import fr.exemole.bdfext.resourcesupdate.api.conversion.Conversion;
import fr.exemole.bdfext.resourcesupdate.api.conversion.ConversionConf;
import fr.exemole.bdfext.resourcesupdate.tools.conversion.ConversionConfBuilder;
import fr.exemole.bdfext.resourcesupdate.tools.conversion.ConversionConfDOMReader;
import fr.exemole.bdfext.resourcesupdate.tools.conversion.zip.IniConversionZipEngine;
import fr.exemole.bdfext.resourcesupdate.tools.conversion.zip.PropertiesConversionZipEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.io.ZipStreamProducer;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SimpleMessageHandler;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConversionZipBdfInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final String name;

    public ConversionZipBdfInstruction(BdfServer bdfServer, String name) {
        this.bdfServer = bdfServer;
        this.name = name;
    }

    public short getBdfUserNeed() {
        return 1;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        Document document;
        if (!StringUtils.isTechnicalName((String)this.name, (boolean)true)) {
            return null;
        }
        if (this.name.equals("_example")) {
            return null;
        }
        DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(ResourcesUpdate.EXTENSION_RESOURCE_ROOT.buildChild("private/conversionzip/" + this.name + ".xml"));
        try (InputStream is = docStream.getInputStream();){
            document = DOMUtils.newDocumentBuilder().parse(is);
        }
        catch (SAXException saxe) {
            return SimpleResponseHandler.init((String)("SAXException: " + saxe.getMessage()));
        }
        catch (IOException ioe) {
            return SimpleResponseHandler.init((String)("IOException: " + ioe.getMessage()));
        }
        SimpleMessageHandler simpleHandler = new SimpleMessageHandler();
        ConversionConfBuilder conversionConfBuilder = new ConversionConfBuilder();
        ConversionConfDOMReader domReader = new ConversionConfDOMReader(this.bdfServer, conversionConfBuilder, (MessageHandler)simpleHandler);
        domReader.readConversionConf(document.getDocumentElement());
        return StreamResponseHandler.init((StreamProducer)new ConversionZipStreamProducer(conversionConfBuilder.toConversionConf(), simpleHandler));
    }

    private static class ConversionZipStreamProducer
    extends ZipStreamProducer {
        private final ConversionConf conversionConf;
        private final SimpleMessageHandler simpleHandler;

        private ConversionZipStreamProducer(ConversionConf conversionConf, SimpleMessageHandler simpleHandler) {
            this.conversionConf = conversionConf;
            this.simpleHandler = simpleHandler;
        }

        public void writeZipStream(ZipOutputStream zipOutputStream) throws IOException {
            String processString = this.simpleHandler.toString();
            if (processString.length() > 0) {
                System.out.println(processString);
                ZipEntry zipEntry = new ZipEntry("log.txt");
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.write((String)processString, (OutputStream)zipOutputStream, (String)"UTF-8");
            }
            String rootPath = "";
            int conversionCount = this.conversionConf.getConversionCount();
            block4: for (int i = 0; i < conversionCount; ++i) {
                Conversion conversion = this.conversionConf.getConversion(i);
                switch (conversion.getMode()) {
                    case 2: {
                        IniConversionZipEngine.zip(conversion, zipOutputStream, rootPath);
                        continue block4;
                    }
                    case 1: {
                        PropertiesConversionZipEngine.zip(conversion, zipOutputStream, rootPath);
                    }
                }
            }
        }
    }
}

