/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.multiidselection;

import fr.exemole.bdfext.multiidselection.MultiIdSelectionSpace;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.roles.Role;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.primitives.FuzzyDate;

public class MultiIdSelectionHistory {
    public static void save(BdfServerEditor bdfServerEditor, Fiches fiches) {
        Role role = bdfServerEditor.getBdfServer().getPermissionManager().getRole("multiidselection");
        if (role == null) {
            return;
        }
        Attribute corpusAttribute = role.getAttributes().getAttribute(MultiIdSelectionSpace.CORPUS_KEY);
        if (corpusAttribute == null) {
            return;
        }
        for (String corpusName : corpusAttribute) {
            try {
                SubsetKey subsetKey = SubsetKey.parse((short)1, (String)corpusName);
                Corpus corpus = (Corpus)bdfServerEditor.getBdfServer().getFichotheque().getSubset(subsetKey);
                if (corpus == null) continue;
                MultiIdSelectionHistory.save(bdfServerEditor, role, corpus, fiches);
            }
            catch (ParseException parseException) {}
        }
    }

    private static void save(BdfServerEditor bdfServerEditor, Role role, Corpus corpus, Fiches fiches) {
        List ficheMetaList = CorpusUtils.getFicheMetaListByCorpus((Fiches)fiches, (Corpus)corpus);
        if (ficheMetaList.isEmpty()) {
            return;
        }
        int max = MultiIdSelectionHistory.getMax(ficheMetaList);
        String dateIso = FuzzyDate.current().toISOString();
        AttributeKey attributeKey = MultiIdSelectionSpace.toKey(corpus.getSubsetKey());
        AttributeBuilder attributeBuilder = new AttributeBuilder(attributeKey);
        attributeBuilder.addValue(dateIso + "," + max);
        Attribute currentAttribute = role.getAttributes().getAttribute(attributeKey);
        if (currentAttribute != null) {
            for (String value : currentAttribute) {
                if (value.startsWith(dateIso)) continue;
                attributeBuilder.addValue(value);
                break;
            }
        }
        bdfServerEditor.putAttribute((Object)role, attributeBuilder.toAttribute());
        role.getAttributes().getAttribute(attributeKey);
    }

    private static int getMax(List<FicheMeta> ficheMetaList) {
        int max = 0;
        for (FicheMeta ficheMeta : ficheMetaList) {
            max = Math.max(max, ficheMeta.getId());
        }
        return max;
    }
}

