/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce;

import fr.exemole.bdfext.icyce.IcyceBdfInstruction;
import fr.exemole.bdfext.icyce.IcyceConstants;
import fr.exemole.bdfext.icyce.IcyceUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.providers.BdfInstructionProvider;
import fr.exemole.bdfserver.tools.instruction.ExitBdfInstruction;
import fr.exemole.bdfserver.tools.instruction.RedirectBdfInstruction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mapeadores.util.request.RequestMap;

public class IcyceBdfInstructionProvider
implements BdfInstructionProvider,
IcyceConstants {
    public BdfInstruction getBdfInstruction(BdfServer bdfServer, String extensionPath, RequestMap requestMap) {
        if (extensionPath.equals("/")) {
            return new RedirectBdfInstruction("index.html");
        }
        if (requestMap.isTrue("bdf-exit")) {
            return new ExitBdfInstruction();
        }
        if (extensionPath.equals("/pays.js")) {
            return new IcyceBdfInstruction(bdfServer, 3, null);
        }
        Pattern pattern = Pattern.compile("^/([a-z]+)(-[a-z0-9]+)?.html$");
        Matcher matcher = pattern.matcher(extensionPath);
        if (!matcher.matches()) {
            return null;
        }
        String actionString = matcher.group(1);
        String paramString = matcher.group(2);
        if (paramString != null) {
            paramString = paramString.substring(1);
        }
        try {
            short action = IcyceUtils.getAction(actionString);
            return new IcyceBdfInstruction(bdfServer, action, paramString);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

