/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce;

import fr.exemole.bdfext.icyce.IcyceUser;
import fr.exemole.bdfext.icyce.IcyceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Pays;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.pointeurs.PointeurFactory;

public class GroupementPays {
    private final Fichotheque fichotheque;
    private Corpus corpus;
    private final List<InternalItem> itemList = new ArrayList<InternalItem>();
    private final Map<String, InternalItem> itemMap = new HashMap<String, InternalItem>();

    public GroupementPays(Fichotheque fichotheque) {
        this.fichotheque = fichotheque;
        this.init();
    }

    public GroupementPays(Fichotheque fichotheque, Motcle groupeLinguistique) {
        this.fichotheque = fichotheque;
        this.init(groupeLinguistique);
    }

    public GroupementPays(Fichotheque fichotheque, IcyceUser icyceUser) {
        this.fichotheque = fichotheque;
        this.init(icyceUser);
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    private void init() {
        this.corpus = IcyceUtils.getConfCorpus(this.fichotheque);
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)this.corpus);
        for (FicheMeta ficheMeta : this.corpus.getFicheMetaList()) {
            fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            FicheItem paysItem = (FicheItem)fichePointeur.getValue(IcyceUtils.PAYS_FIELDKEY);
            if (paysItem == null || !(paysItem instanceof Pays)) continue;
            Pays pays = (Pays)paysItem;
            this.put(pays, ficheMeta);
        }
    }

    private void init(Motcle groupeLinguistique) {
        this.corpus = IcyceUtils.getConfCorpus(this.fichotheque);
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)this.corpus);
        Croisements ficheCroisements = this.fichotheque.getCroisements((SubsetItem)groupeLinguistique, (Subset)this.corpus);
        for (Croisements.Entry entry : ficheCroisements.getEntryList()) {
            FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
            fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            FicheItem paysItem = (FicheItem)fichePointeur.getValue(IcyceUtils.PAYS_FIELDKEY);
            if (paysItem == null || !(paysItem instanceof Pays)) continue;
            Pays pays = (Pays)paysItem;
            this.put(pays, ficheMeta);
        }
    }

    private void init(IcyceUser icyceUser) {
        this.corpus = IcyceUtils.getConfCorpus(this.fichotheque);
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)this.corpus);
        int length = icyceUser.getConferenceCount();
        for (int i = 0; i < length; ++i) {
            FicheMeta ficheMeta = this.corpus.getFicheMetaById(icyceUser.getConferenceId(i));
            if (ficheMeta == null) continue;
            fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            FicheItem paysItem = (FicheItem)fichePointeur.getValue(IcyceUtils.PAYS_FIELDKEY);
            if (paysItem == null || !(paysItem instanceof Pays)) continue;
            Pays pays = (Pays)paysItem;
            this.put(pays, ficheMeta);
        }
    }

    private void put(Pays pays, FicheMeta ficheMeta) {
        String countryCode = pays.getCountry().toString();
        InternalItem internalItem = this.itemMap.get(countryCode);
        if (internalItem == null) {
            internalItem = new InternalItem(pays);
            this.itemList.add(internalItem);
            this.itemMap.put(countryCode, internalItem);
        }
        internalItem.add(ficheMeta);
    }

    public int getPaysCount() {
        return this.itemList.size();
    }

    public PaysItem getPaysItem(int i) {
        return this.itemList.get(i);
    }

    private class InternalItem
    implements PaysItem {
        private final Pays pays;
        private final List<FicheMeta> list = new ArrayList<FicheMeta>();

        InternalItem(Pays pays) {
            this.pays = pays;
        }

        @Override
        public Pays getPays() {
            return this.pays;
        }

        private void add(FicheMeta ficheMeta) {
            this.list.add(ficheMeta);
        }

        @Override
        public int getFicheMetaCount() {
            return this.list.size();
        }

        @Override
        public FicheMeta getFicheMeta(int i) {
            return this.list.get(i);
        }
    }

    public static interface PaysItem {
        public Pays getPays();

        public int getFicheMetaCount();

        public FicheMeta getFicheMeta(int var1);
    }
}

