/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation.builders;

import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.tools.ventilation.VentilationBuilderUtils;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.desmodo.atlas.ventilation.builders.DefaultVentilation;

public class CompleteVentilationBuilder {
    private CompleteVentilationBuilder() {
    }

    public static Ventilation toVentilation(VentilationParameters ventilationParameters) throws UnsupportedVentilationRootException {
        boolean ignoreHorsGrille = ventilationParameters.getSessionConf().getBoolean("ignore.contexte.horsgrille");
        DefaultVentilation ventilation = DefaultVentilation.createVentilationComplete(ventilationParameters, ignoreHorsGrille);
        Term ventilationRoot = ventilationParameters.getVentilationRoot();
        if (ventilationRoot != null) {
            if (ventilationRoot instanceof Descripteur) {
                Descripteur descripteur = (Descripteur)ventilationRoot;
                VentilationBuilderUtils.addLiaisonsNaturelles(descripteur, ventilation);
            } else if (ventilationRoot instanceof Contexte) {
                Contexte contexte = (Contexte)ventilationRoot;
                VentilationBuilderUtils.addLiaisonsNaturelles(contexte, ventilation);
            } else {
                throw new UnsupportedVentilationRootException("ventilation:complete supports only Contexte or Descripteur as VentilationRoot", CompleteVentilationBuilder.class.getName());
            }
        }
        ventilation.endInit();
        return ventilation;
    }
}

