/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tools.ventilation;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.tools.ventilation.VentilationBuilder;
import net.desmodo.atlas.tools.ventilation.VentilationBuilderUtils;
import net.desmodo.atlas.tools.ventilation.VentilationUtils;
import net.desmodo.atlas.ventilation.UnsupportedVentilationNameException;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.desmodo.atlas.ventilation.builders.ByFamilleVentilationBuilder;
import net.desmodo.atlas.ventilation.builders.CompleteVentilationBuilder;
import net.desmodo.atlas.ventilation.builders.DescripteurListVentilationBuilder;
import net.desmodo.atlas.ventilation.builders.GrilleVentilationBuilder;
import net.mapeadores.util.exceptions.NestedNoSuchMethodException;
import net.mapeadores.util.exceptions.NestedScriptException;
import net.mapeadores.util.script.ScriptFamily;
import net.mapeadores.util.script.ScriptFamilyProvider;

public class DefaultVentilationFactory
implements VentilationFactory {
    private ScriptFamilyProvider scriptFamilyProvider;

    public DefaultVentilationFactory(ScriptFamilyProvider scriptFamilyProvider) {
        this.scriptFamilyProvider = scriptFamilyProvider;
    }

    @Override
    public Ventilation getVentilation(VentilationParameters ventilationParameters) throws UnsupportedVentilationNameException, UnsupportedVentilationRootException {
        VentilationName ventilationName = ventilationParameters.getVentilationName();
        String nameSpace = ventilationName.getNameSpace();
        if (nameSpace.equals("script")) {
            ScriptFamily scriptFamily;
            if (this.scriptFamilyProvider != null && (scriptFamily = this.scriptFamilyProvider.getScriptFamily(ventilationName.getLocalName())) != null && scriptFamily.hasScriptFor("build-ventilation")) {
                return DefaultVentilationFactory.getVentilationByScript(ventilationParameters, scriptFamily);
            }
        } else if (nameSpace.equals("ventilation")) {
            if (ventilationName.equals(VentilationName.VENTILATION_NATURELLE)) {
                ventilationName = VentilationUtils.getVentilationNaturelle(ventilationParameters.getVentilationRoot());
            }
            if (ventilationName.equals(VentilationName.VENTILATION_COMPLETE)) {
                return CompleteVentilationBuilder.toVentilation(ventilationParameters);
            }
            if (ventilationName.equals(VentilationName.VENTILATION_BYFAMILLE)) {
                return ByFamilleVentilationBuilder.toVentilation(ventilationParameters);
            }
            Term ventilationTerm = ventilationName.getTerm();
            if (ventilationTerm != null) {
                short type = ventilationTerm.getTermType();
                if (type == 2 || type == 3) {
                    return GrilleVentilationBuilder.toVentilation(ventilationParameters, ventilationTerm);
                }
                if (type == 4) {
                    return DescripteurListVentilationBuilder.toVentilation(ventilationParameters, (Contexte)ventilationTerm);
                }
            }
        }
        throw new UnsupportedVentilationNameException(this.getClass().getName(), ventilationName.toUriString());
    }

    private static Ventilation getVentilationByScript(VentilationParameters ventilationParameters, ScriptFamily scriptFamily) {
        VentilationBuilder ventilationBuilder = new VentilationBuilder(ventilationParameters);
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine jsEngine = factory.getEngineByName("javascript");
        jsEngine.put("utils", VentilationBuilderUtils.UNIQUE_INSTANCE);
        try {
            scriptFamily.evalScriptFor("build-ventilation", jsEngine);
            Invocable invocableEngine = (Invocable)((Object)jsEngine);
            invocableEngine.invokeFunction("buildVentilation", ventilationBuilder);
        }
        catch (ScriptException se) {
            throw new NestedScriptException(se);
        }
        catch (NoSuchMethodException nsme) {
            throw new NestedNoSuchMethodException(nsme);
        }
        return ventilationBuilder.toVentilation();
    }
}

