/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.session;

import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.session.Navigation;
import net.desmodo.atlas.session.NavigationUnit;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.ventilation.Transversalite;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationName;
import net.mapeadores.util.localisation.Lang;

public class NavigationUtils
implements SessionConfKeys {
    private NavigationUtils() {
    }

    public static Lang getWorkingLang(Navigation navigation) {
        return navigation.getSession().getSessionConf().getLang("lang.current");
    }

    public static String toString(NavigationUnit navigationUnit) {
        StringBuilder buf = new StringBuilder();
        Term terme = navigationUnit.getVentilation().getRoot();
        if (terme != null) {
            if (terme instanceof Descripteur) {
                buf.append("d-");
                buf.append(((Descripteur)terme).getIddesc().toString());
            } else if (terme instanceof Contexte) {
                Contexte contexte = (Contexte)terme;
                buf.append("c-");
                buf.append(contexte.getGrille().getGrilleName());
                buf.append("-");
                buf.append(contexte.getIdctxt());
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public static List<NavigationUnit> balaie(Navigation navigation, Grille grille) {
        Navigation clone = new Navigation(navigation);
        ArrayList<NavigationUnit> liste = new ArrayList<NavigationUnit>();
        ContexteList contexteList = grille.getFirstLevelContexteList();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            Contexte contexte = contexteList.getContexte(i);
            clone.changeVentilationRoot(contexte);
            liste.add(NavigationUtils.clone(clone.getCurrentNavigationUnit()));
        }
        clone.unbind();
        return liste;
    }

    public static List<NavigationUnit> balaie(Navigation navigation, Contexte contexte) {
        Navigation clone = new Navigation(navigation);
        List<NavigationUnit> liste = StructureUtils.isFamilleOrSansfamille(contexte) ? NavigationUtils.balaieFamille(clone, contexte) : NavigationUtils.balaieContexte(clone, contexte);
        clone.unbind();
        return liste;
    }

    private static List<NavigationUnit> balaieFamille(Navigation clone, Contexte famille) {
        ArrayList<NavigationUnit> liste = new ArrayList<NavigationUnit>();
        Descripteurs descripteurs = clone.getSession().getAtlas().getDescripteurs();
        DescripteurList descripteurList = descripteurs.getInFamilleDescripteurList(famille);
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int i = 0; i < descripteurCount; ++i) {
            clone.changeVentilationRoot(descripteurList.getDescripteur(i));
            liste.add(NavigationUtils.clone(clone.getCurrentNavigationUnit()));
        }
        return liste;
    }

    private static List<NavigationUnit> balaieContexte(Navigation clone, Contexte contexteParent) {
        ArrayList<NavigationUnit> liste = new ArrayList<NavigationUnit>();
        ContexteList contexteList = contexteParent.getChildren();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            clone.changeVentilationRoot(contexteList.getContexte(i));
            liste.add(NavigationUtils.clone(clone.getCurrentNavigationUnit()));
        }
        return liste;
    }

    public static NavigationUnit clone(NavigationUnit navigationUnit) {
        CloneNavigationUnit nav = new CloneNavigationUnit(navigationUnit);
        return nav;
    }

    private static class CloneNavigationUnit
    implements NavigationUnit {
        private final Ventilation ventilation;
        private final Transversalite transversalite;
        private final VentilationName ventilationName;

        private CloneNavigationUnit(NavigationUnit navigationUnit) {
            this.ventilation = navigationUnit.getVentilation();
            this.ventilationName = navigationUnit.getVentilationName();
            this.transversalite = navigationUnit.getTransversalite();
        }

        @Override
        public VentilationName getVentilationName() {
            return this.ventilationName;
        }

        @Override
        public Transversalite getTransversalite() {
            return this.transversalite;
        }

        @Override
        public Ventilation getVentilation() {
            return this.ventilation;
        }
    }
}

