/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.structure.Contexte;

class LienHierarchiqueGroupImpl
implements LienHierarchiqueGroup {
    private Descripteur descripteurPere;
    private Contexte contexte;
    private List<InternalLienHierarchique> lienHierarchiqueList;

    LienHierarchiqueGroupImpl(Descripteur descripteurPere, Contexte contexte) {
        this.descripteurPere = descripteurPere;
        this.contexte = contexte;
        this.lienHierarchiqueList = new ArrayList<InternalLienHierarchique>();
    }

    @Override
    public Descripteur getDescripteurPere() {
        return this.descripteurPere;
    }

    @Override
    public Contexte getContexte() {
        return this.contexte;
    }

    @Override
    public int getLienHierarchiqueCount() {
        return this.lienHierarchiqueList.size();
    }

    @Override
    public LienHierarchique getLienHierarchique(int i) {
        return this.lienHierarchiqueList.get(i);
    }

    LienHierarchique addFils(Descripteur descfils, int n) {
        InternalLienHierarchique lh = null;
        int tailleactu = this.lienHierarchiqueList.size();
        if (n < 0 || n >= tailleactu) {
            lh = new InternalLienHierarchique(descfils, tailleactu);
            this.lienHierarchiqueList.add(lh);
        } else {
            lh = new InternalLienHierarchique(descfils, n);
            this.lienHierarchiqueList.add(n, lh);
            for (int i = n + 1; i < tailleactu + 1; ++i) {
                InternalLienHierarchique dlh = this.lienHierarchiqueList.get(i);
                ++dlh.index;
            }
        }
        return lh;
    }

    LienHierarchique removeFils(Descripteur descfils) {
        boolean remove = false;
        InternalLienHierarchique removedlh = null;
        Iterator<InternalLienHierarchique> it = this.lienHierarchiqueList.iterator();
        while (it.hasNext()) {
            InternalLienHierarchique dlh = it.next();
            if (remove) {
                --dlh.index;
                continue;
            }
            if (!dlh.descripteurfils.equals(descfils)) continue;
            removedlh = dlh;
            it.remove();
            remove = true;
        }
        return removedlh;
    }

    LienHierarchique setIndex(int n1, int n2) throws IndexOutOfBoundsException {
        int taille = this.lienHierarchiqueList.size();
        if (n2 < 0 || n2 >= taille) {
            n2 = taille - 1;
        }
        if (n1 == n2) {
            return null;
        }
        if (n1 < 0 || n1 >= taille) {
            throw new IndexOutOfBoundsException();
        }
        InternalLienHierarchique lh = this.lienHierarchiqueList.get(n1);
        this.lienHierarchiqueList.remove(n1);
        lh.index = n2;
        this.lienHierarchiqueList.add(n2, lh);
        if (n1 < n2) {
            for (int i = n1; i < n2; ++i) {
                InternalLienHierarchique dlh = this.lienHierarchiqueList.get(i);
                --dlh.index;
            }
        } else {
            for (int i = n2 + 1; i <= n1; ++i) {
                InternalLienHierarchique dlh = this.lienHierarchiqueList.get(i);
                ++dlh.index;
            }
        }
        return lh;
    }

    private class InternalLienHierarchique
    implements LienHierarchique {
        Descripteur descripteurfils;
        int index;

        InternalLienHierarchique(Descripteur descripteurfils, int index) {
            this.descripteurfils = descripteurfils;
            this.index = index;
        }

        @Override
        public Descripteur getDescripteurPere() {
            return LienHierarchiqueGroupImpl.this.descripteurPere;
        }

        @Override
        public Descripteur getDescripteurFils() {
            return this.descripteurfils;
        }

        @Override
        public int getLienHierarchiqueIndex() {
            return this.index;
        }

        @Override
        public LienHierarchiqueGroup getLienHierarchiqueGroup() {
            return LienHierarchiqueGroupImpl.this;
        }

        @Override
        public Contexte getContexte() {
            return LienHierarchiqueGroupImpl.this.contexte;
        }
    }
}

