/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.event;

import java.util.EventObject;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.structure.Contexte;

public class LienEvent
extends EventObject {
    public static final short LIEN_REMOVED = 1;
    public static final short LIEN_ADDED = 2;
    public static final short INDEX_CHANGED = 3;
    public static final short CONTEXTE_CHANGED = 4;
    public static final short DESCRIPTEUR_ADDED = 4;
    private short lienEventType;
    private Lien lien;
    private int oldIndex;
    private int newIndex;
    private int descripteurInLienStructurelIndex;
    private Descripteur removedDescripteur;
    private Contexte oldContexte;
    private int oldContexteIndex;

    private LienEvent(Liens liens, short lienEventType, Lien lien) {
        super(liens);
        this.lienEventType = lienEventType;
        this.lien = lien;
    }

    public static LienEvent createDescripteurAddedEvent(Liens liens, LienStructurel lienStructurel, int index) {
        LienEvent lienEvent = new LienEvent(liens, 4, lienStructurel);
        lienEvent.descripteurInLienStructurelIndex = index;
        return lienEvent;
    }

    public static LienEvent createDescripteurRemovedEvent(Liens liens, LienStructurel lienStructurel, Descripteur removedDescripteur, int oldIndex) {
        LienEvent lienEvent = new LienEvent(liens, 4, lienStructurel);
        lienEvent.oldIndex = oldIndex;
        lienEvent.removedDescripteur = removedDescripteur;
        return lienEvent;
    }

    public static LienEvent createIndexChangedEvent(Liens liens, LienStructurel lien, int oldIndex, int newIndex) {
        LienEvent lienEvent = new LienEvent(liens, 3, lien);
        lienEvent.oldIndex = oldIndex;
        lienEvent.newIndex = newIndex;
        return lienEvent;
    }

    public static LienEvent createIndexChangedEvent(Liens liens, LienHierarchique lien, int oldIndex, int newIndex) {
        LienEvent lienEvent = new LienEvent(liens, 3, lien);
        lienEvent.oldIndex = oldIndex;
        lienEvent.newIndex = newIndex;
        return lienEvent;
    }

    public static LienEvent createLienAddedEvent(Liens liens, LienHierarchique lien, int newIndex) {
        LienEvent lienEvent = new LienEvent(liens, 2, lien);
        lienEvent.newIndex = newIndex;
        return lienEvent;
    }

    public static LienEvent createLienAddedEvent(Liens liens, LienSymetrique lien) {
        LienEvent lienEvent = new LienEvent(liens, 2, lien);
        return lienEvent;
    }

    public static LienEvent createContexteChangedEvent(Liens liens, LienSymetrique lien, int oldContexteIndex, Contexte oldContexte) {
        LienEvent lienEvent = new LienEvent(liens, 4, lien);
        lienEvent.oldContexte = oldContexte;
        lienEvent.oldContexteIndex = oldContexteIndex;
        return lienEvent;
    }

    public static LienEvent createLienRemovedEvent(Liens liens, LienSymetrique lien) {
        LienEvent lienEvent = new LienEvent(liens, 1, lien);
        return lienEvent;
    }

    public static LienEvent createLienRemovedEvent(Liens liens, LienHierarchique lien, int oldIndex) {
        LienEvent lienEvent = new LienEvent(liens, 1, lien);
        lienEvent.oldIndex = oldIndex;
        return lienEvent;
    }

    public Liens getLiens() {
        return (Liens)this.getSource();
    }

    public Lien getLien() {
        return this.lien;
    }

    public short getLienEventType() {
        return this.lienEventType;
    }

    public int getOldIndex() {
        return this.oldIndex;
    }

    public int getNewIndex() {
        return this.newIndex;
    }

    public Descripteur getRemovedDescripteur() {
        return this.removedDescripteur;
    }

    public Contexte getOldContexte() {
        return this.oldContexte;
    }

    public int getOldContexteIndex() {
        return this.oldContexteIndex;
    }
}

