/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.cartecentree;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.boxes.TextBox;
import net.desmodo.atlas.boxes.TextBoxManager;
import net.desmodo.atlas.display.blocks.BlockUtils;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.blocks.TransversalLine;
import net.desmodo.atlas.display.layers.cartecentree.ChapeauxLayer;
import net.desmodo.atlas.display.layers.common.LiaisonBlockLayer;
import net.desmodo.atlas.display.overflow.DefaultOverflow;
import net.desmodo.atlas.display.overflow.Overflow;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaireUtils;
import net.desmodo.atlas.session.NavigationUnit;
import net.desmodo.atlas.tools.ventilation.VentilationUtils;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.Transversalite;
import net.desmodo.atlas.ventilation.Ventilation;
import net.mapeadores.util.awt.FontInfo;
import net.mapeadores.util.geometry.CartesianOrigin;
import net.mapeadores.util.geometry.CartesianPoint;
import net.mapeadores.util.geometry.CartesianUtils;

public class CartecentreeLayer {
    private FaisceauAngulaire faisceauAngulaire;
    private final TextBoxManager textBoxManager;
    private Dimension AB = new Dimension(10, 10);
    private Dimension bordureDim = new Dimension(20, 20);
    private final CartesianOrigin cartesianOrigin = new CartesianOrigin();
    private final CartesianPoint faisceauCartesianCenter = new CartesianPoint(0, 0);
    private final List<LibelleBlock> bordureBoxes = new LinkedList<LibelleBlock>();
    private final Map<Integer, LibelleBlock> bordureBlocksMap = new HashMap<Integer, LibelleBlock>();
    private LibelleBlock centralBlock = null;
    private final LiaisonBlockLayer liaisonBlockLayer;
    private final LinkedList transversalLineList = new LinkedList();
    private final FontInfo fontInfo;
    private int secteurvisibility = -2;
    private final InternalOverflow internalOverflowManager = new InternalOverflow();
    private final ChapeauxLayer chapeauxLayer;

    public CartecentreeLayer(TextBoxManager textBoxManager, Dimension dim, FontInfo fontInfo) {
        this.textBoxManager = textBoxManager;
        this.liaisonBlockLayer = new LiaisonBlockLayer(textBoxManager);
        this.chapeauxLayer = new ChapeauxLayer(textBoxManager);
        this.fontInfo = fontInfo;
        this.setAllowedSize(dim, false);
    }

    public void reinit(NavigationUnit navigationUnit) {
        this.setVentilation(navigationUnit);
        this.setTransversalite(navigationUnit.getTransversalite());
    }

    public void setVentilation(NavigationUnit navigationUnit) {
        this.setVentilation(navigationUnit.getVentilation());
        this.initSecteurVisibility(navigationUnit);
    }

    public int getSecteurVisibility() {
        return this.secteurvisibility;
    }

    public CartesianOrigin getCartesianOrigin() {
        return this.cartesianOrigin;
    }

    public FaisceauAngulaire getFaisceauAngulaire() {
        return this.faisceauAngulaire;
    }

    public ChapeauxLayer getChapeauxLayer() {
        return this.chapeauxLayer;
    }

    public Set getUsedColorStyle() {
        if (this.faisceauAngulaire == null) {
            return Collections.EMPTY_SET;
        }
        return this.faisceauAngulaire.getUsedColorStyle();
    }

    public Set getUsedBoxSkin() {
        HashSet<BoxSkin> hashSet = new HashSet<BoxSkin>();
        if (this.centralBlock != null) {
            hashSet.add(this.centralBlock.getBoxSkin());
        }
        if (this.bordureBoxes != null && this.bordureBoxes.size() > 0) {
            hashSet.add(this.bordureBoxes.get(0).getBoxSkin());
        }
        hashSet.addAll(this.chapeauxLayer.getUsedBoxSkin());
        for (LiaisonBlock liaisonBlock : this.liaisonBlockLayer.getLiaisonBlockList()) {
            hashSet.add(liaisonBlock.getBoxSkin());
        }
        return hashSet;
    }

    public LibelleBlock getCentralBlock() {
        return this.centralBlock;
    }

    public LiaisonBlockLayer getLiaisonBlockLayer() {
        return this.liaisonBlockLayer;
    }

    public LibelleBlock getBordureBlock(Secteur secteur) {
        return this.bordureBlocksMap.get(secteur.getSecteurTerm().getCode());
    }

    public List getBordureLibelleList() {
        return this.bordureBoxes;
    }

    public List getTransversalLineList() {
        return this.transversalLineList;
    }

    public Secteur getSecteurAt(Point P) {
        return SecteurAngulaireUtils.getSecteur(this.faisceauAngulaire, this.cartesianOrigin.toCartesianPoint(P));
    }

    public void setAllowedSize(Dimension dim) {
        this.setAllowedSize(dim, true);
    }

    public Overflow getOverflow() {
        return this.internalOverflowManager;
    }

    public void setTransversalite(Transversalite transversalite) {
        this.transversalLineList.clear();
        if (transversalite != null) {
            List<Transversalite.TransversaliteItem> liste = transversalite.getTransversaliteItemList();
            for (Transversalite.TransversaliteItem item : liste) {
                LiaisonBlock block2;
                LiaisonBlock block1 = this.liaisonBlockLayer.getLiaisonBlock(item.getLiaison1VentilationCode());
                if (block1 == null || (block2 = this.liaisonBlockLayer.getLiaisonBlock(item.getLiaison2VentilationCode())) == null) continue;
                this.transversalLineList.add(new TransversalLine(block1, block2, item.getTransversaliteType()));
            }
        }
    }

    private void setAllowedSize(Dimension dim, boolean reinit) {
        this.testDim(dim);
        this.internalOverflowManager.setAllowedSize(dim);
        int ox = dim.width / 2;
        int oy = dim.height / 2;
        Point translation = this.cartesianOrigin.setGraphicCoordinates(ox, oy);
        int lineHeight = this.fontInfo.getLineHeight();
        int lg = this.fontInfo.getMCharWidth() * 7;
        int a = ox - lg;
        int b = oy - lineHeight * 2;
        if (a < 10) {
            a = 10;
        }
        if (b < 10) {
            b = 10;
        }
        this.AB = new Dimension(a, b);
        int brdWdth = ox - lg / 3;
        int brdHgt = oy - lineHeight;
        if (brdWdth < 15) {
            brdWdth = 15;
        }
        if (brdHgt < 15) {
            brdHgt = 15;
        }
        this.bordureDim = new Dimension(brdWdth, brdHgt);
        this.chapeauxLayer.redim(dim, this.fontInfo);
        if (reinit) {
            this.faisceauAngulaire.redim(this.faisceauCartesianCenter, this.AB);
            this.chapeauxLayer.reinit(this.faisceauAngulaire, this.cartesianOrigin);
            this.initBordureBoxes();
            if (this.centralBlock != null) {
                this.centralBlock.getRectangle().translate(translation.x, translation.y);
            }
            this.initliaisonBlocks(false);
        }
    }

    private void testDim(Dimension dim) {
        if (dim.width < 32) {
            dim.width = 32;
        }
        if (dim.height < 32) {
            dim.height = 32;
        }
    }

    private void initBordureBoxes() {
        this.bordureBoxes.clear();
        this.bordureBlocksMap.clear();
        int lng = this.faisceauAngulaire.getSecteurAngulaireCount();
        for (int i = 0; i < lng; ++i) {
            SecteurAngulaire secteurAngulaire = this.faisceauAngulaire.getSecteurAngulaire(i);
            Secteur secteur = secteurAngulaire.getSecteur();
            Term termeSecteur = secteur.getSecteurTerm();
            TextBox textBox = this.textBoxManager.getTextBox((short)0, termeSecteur.getCode());
            LibelleBlock libelleBlock = this.createBordureLibelleBlock(termeSecteur, secteurAngulaire, textBox);
            this.bordureBoxes.add(libelleBlock);
            this.bordureBlocksMap.put(secteur.getSecteurTerm().getCode(), libelleBlock);
        }
    }

    private LibelleBlock createBordureLibelleBlock(Term secteurTerm, SecteurAngulaire secteurAngulaire, TextBox textBox) {
        Dimension dim = textBox.getDimension();
        double angle = SecteurAngulaireUtils.getCartesianEllipseAngle(secteurAngulaire, 0.5f);
        CartesianPoint P = CartesianUtils.getAngleIntersection((CartesianPoint)this.faisceauAngulaire.getCartesianCenter(), (double)angle, (int)(this.bordureDim.width - dim.width / 2), (int)(this.bordureDim.height - dim.height / 2));
        Point center = this.cartesianOrigin.toGraphicPoint(P);
        Point L = BlockUtils.getNorthWest(center, 0, dim);
        return new LibelleBlock(secteurTerm, 3, textBox, new Rectangle(L, dim));
    }

    private void setVentilation(Ventilation ventilation) {
        this.initcentralBlock(ventilation);
        this.faisceauAngulaire = new FaisceauAngulaire(ventilation, 0.0, Math.PI * 2);
        this.faisceauAngulaire.redim(this.faisceauCartesianCenter, this.AB);
        this.chapeauxLayer.reinit(this.faisceauAngulaire, this.cartesianOrigin);
        this.initBordureBoxes();
        this.initliaisonBlocks(true);
    }

    private void initcentralBlock(Ventilation ventilation) {
        Term root = ventilation.getRoot();
        if (root == null) {
            this.centralBlock = null;
        } else {
            TextBox textBox = this.textBoxManager.getTextBox((short)4, root.getCode());
            Dimension dim = textBox.getDimension();
            Point L = BlockUtils.getNorthWest(this.cartesianOrigin.toGraphicPoint(this.faisceauCartesianCenter), 0, dim);
            Rectangle rectangle = new Rectangle(L, dim);
            this.centralBlock = new LibelleBlock(root, 1, textBox, rectangle);
        }
    }

    private void initliaisonBlocks(boolean clearboxes) {
        Object centralRect = null;
        this.liaisonBlockLayer.clearExistingRectangles();
        if (this.centralBlock != null) {
            this.liaisonBlockLayer.addExistingRectangle(this.centralBlock.getRectangle(), 26);
        }
        for (LibelleBlock intlib : this.bordureBoxes) {
            TextBox.Line line = intlib.getTextBox().getLine(0);
            Point L = intlib.getLocation();
            Point P = line.getStartPoint();
            int x = L.x + P.x + line.getLineLength() / 2 - 6;
            int y = L.y + P.y - (line.getLineAscent() - 2);
            this.liaisonBlockLayer.addExistingRectangle(new Rectangle(x, y, 12, line.getLineAscent() - 4), 0);
        }
        this.liaisonBlockLayer.init(this.faisceauAngulaire, this.cartesianOrigin, clearboxes);
        this.internalOverflowManager.checkOverflow(this.liaisonBlockLayer.getGlobalRectangle());
    }

    private void initSecteurVisibility(NavigationUnit navigationUnit) {
        if (this.faisceauAngulaire == null) {
            this.secteurvisibility = -2;
        } else {
            this.secteurvisibility = this.faisceauAngulaire.getSecteurAngulaireCount();
            if (this.secteurvisibility == 0) {
                Secteur secteur = VentilationUtils.getFirstActiveSecteur(navigationUnit.getVentilation());
                this.secteurvisibility = secteur == null ? -2 : -1;
            }
        }
    }

    private class InternalOverflow
    extends DefaultOverflow {
        private InternalOverflow() {
            super(new Dimension(0, 0));
        }

        private void setAllowedSize(Dimension dim) {
            this.reinitAllowedSize(dim);
        }

        @Override
        protected void checkOverflow(Rectangle rectangle) {
            this.clearOverflow();
            super.checkOverflow(rectangle);
        }
    }
}

