/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.json;

import fr.exemole.bdfext.desmoservice.DesmoserviceUtils;
import fr.exemole.bdfext.desmoservice.api.Desmographie;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfext.desmoservice.json.ParameterErrorException;
import fr.exemole.bdfext.desmoservice.json.WarningHandler;
import fr.exemole.bdfext.desmoservice.tools.SearchEngine;
import fr.exemole.bdfserver.api.BdfServer;
import java.text.ParseException;
import java.util.Collection;
import java.util.TreeMap;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.conf.StringMapConf;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.json.api.FamilleSelection;
import net.desmodo.atlas.json.api.FieldFilter;
import net.desmodo.atlas.json.producers.AbstractJsonProducer;
import net.desmodo.atlas.json.producers.ErrorJsonProducer;
import net.desmodo.atlas.json.producers.FamillesJsonProducer;
import net.desmodo.atlas.json.producers.LexieDistributionJsonProducer;
import net.desmodo.atlas.json.producers.StructureJsonProducer;
import net.desmodo.atlas.json.producers.TermsJsonProducer;
import net.desmodo.atlas.json.producers.VentilationJsonProducer;
import net.desmodo.atlas.json.tools.FamilleSelectionBuilder;
import net.desmodo.atlas.json.tools.FieldFilterBuilder;
import net.desmodo.atlas.session.ConfLiaisonFilter;
import net.desmodo.atlas.session.SessionUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.tools.ventilation.DefaultVentilationFactory;
import net.desmodo.atlas.ventilation.LiaisonFilter;
import net.desmodo.atlas.ventilation.UnsupportedVentilationNameException;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.Comparators;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.geometry.CartesianPoint;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.net.UUIDURI;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class JsonProducerFactory {
    private JsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(BdfServer bdfServer, DesmoserviceContext desmoserviceContext, RequestMap requestMap) {
        AbstractJsonProducer abstractJsonProducer;
        WarningHandler warningHandler = new WarningHandler();
        try {
            abstractJsonProducer = JsonProducerFactory.getJsonProducer(bdfServer, desmoserviceContext, requestMap, warningHandler);
        }
        catch (ParameterErrorException pee) {
            abstractJsonProducer = new ErrorJsonProducer(pee.getErrorKey(), pee.getParameter(), pee.getValue());
        }
        if (!warningHandler.isEmpty() && requestMap.isTrue("warnings")) {
            abstractJsonProducer.setWarningList(warningHandler.toWarningList());
        }
        return abstractJsonProducer;
    }

    private static AbstractJsonProducer getJsonProducer(BdfServer bdfServer, DesmoserviceContext desmoserviceContext, RequestMap requestMap, WarningHandler warningHandler) {
        String type = JsonProducerFactory.getMandatoryValue(requestMap, "type");
        String desmo = JsonProducerFactory.getMandatoryValue(requestMap, "desmo");
        Desmographie desmographie = desmoserviceContext.getDesmoserviceCache().getDesmographie(desmo);
        if (desmographie == null) {
            throw new ParameterErrorException("unknownParameterValue", "desmo", desmo);
        }
        if (type.equals("ventilation")) {
            DefaultVentilationFactory ventilationFactory = new DefaultVentilationFactory(desmoserviceContext.getScriptFamilyProvider());
            return JsonProducerFactory.getVentilationJsonProducer(requestMap, ventilationFactory, desmographie);
        }
        if (type.equals("structure")) {
            return JsonProducerFactory.getStructureJsonProducer(requestMap, desmographie);
        }
        if (type.equals("familles")) {
            return JsonProducerFactory.getFamillesJsonProducer(requestMap, desmographie);
        }
        if (type.equals("lexiedistribution")) {
            return JsonProducerFactory.getLexieDistributionJsonProducer(requestMap, desmographie);
        }
        if (type.equals("terms")) {
            return JsonProducerFactory.getTermsJsonProducer(bdfServer, requestMap, desmoserviceContext, desmographie);
        }
        throw new ParameterErrorException("unknownParameterValue", "type", type);
    }

    private static AbstractJsonProducer getTermsJsonProducer(BdfServer bdfServer, RequestMap requestMap, DesmoserviceContext desmoserviceContext, Desmographie desmographie) {
        Collection<Term> termCollection;
        String qParameter = requestMap.getParameter("q");
        FamilleSelection familleSelection = JsonProducerFactory.getFamilleSelection(requestMap, desmographie.getAtlas());
        Lang lang = JsonProducerFactory.getLang(requestMap);
        if (qParameter != null) {
            TextCondition condition = ConditionsUtils.parseSimpleCondition((String)JsonProducerFactory.getMandatoryValue(requestMap, "q"));
            termCollection = SearchEngine.search(bdfServer, desmoserviceContext, desmographie, condition, lang, familleSelection);
        } else {
            Atlas atlas = desmographie.getAtlas();
            String prefix = desmographie.getName() + "/";
            Thesaurus descripteurThesaurus = desmoserviceContext.getCoreAliasHolder().getThesaurus("descripteur");
            TreeMap<Motcle, Term> termMap = new TreeMap<Motcle, Term>(Comparators.label((Lang)lang));
            for (Motcle motcle : descripteurThesaurus.getMotcleList()) {
                int code;
                Term term;
                if (!motcle.getIdalpha().startsWith(prefix) || (term = atlas.getTerm(code = BdfAtlasUtils.getTermCode(motcle, (short)1))) == null) continue;
                termMap.put(motcle, term);
            }
            termCollection = termMap.values();
        }
        FieldFilter termFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "");
        if (termFieldFilter == null) {
            termFieldFilter = FieldFilterBuilder.DEFAULT_FIELDFILTER;
        }
        return new TermsJsonProducer(termCollection, termFieldFilter);
    }

    private static AbstractJsonProducer getVentilationJsonProducer(RequestMap requestMap, VentilationFactory ventilationFactory, Desmographie desmographie) {
        FieldFilter liaisonFieldFilter;
        FieldFilter secteurFieldFilter;
        FieldFilter rootFieldFilter;
        String name = JsonProducerFactory.getMandatoryValue(requestMap, "name");
        FieldFilter defaultFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "");
        if (defaultFieldFilter == null) {
            defaultFieldFilter = FieldFilterBuilder.DEFAULT_FIELDFILTER;
        }
        if ((rootFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "_root")) == null) {
            rootFieldFilter = defaultFieldFilter;
        }
        if ((secteurFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "_secteur")) == null) {
            secteurFieldFilter = defaultFieldFilter;
        }
        if ((liaisonFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "_liaison")) == null) {
            liaisonFieldFilter = defaultFieldFilter;
        }
        StringMapConf conf = DesmoserviceUtils.checkConf(requestMap, desmographie.getSessionConf());
        Atlas atlas = desmographie.getAtlas();
        Term term = null;
        String root = requestMap.getParameter("root_uri");
        if (root != null) {
            if (root.equals("home")) {
                String ventilationRootString = conf.getString("home.ventilationroot");
                term = SessionUtils.getHomeTerm(ventilationRootString, atlas);
                if (term == null) {
                    throw new ParameterErrorException("wrongHomeValue", "root_uri", ventilationRootString);
                }
            } else {
                try {
                    UUIDURI uri = UUIDURI.parse((String)root);
                    term = AtlasURI.parse(atlas, uri);
                }
                catch (ParseException pe) {
                    throw new ParameterErrorException("malformedParameterValue", "root_uri", root);
                }
                if (term == null) {
                    throw new ParameterErrorException("unknownParameterValue", "root_uri", root);
                }
            }
        } else {
            root = requestMap.getParameter("root_code");
            if (root != null) {
                try {
                    int code = Integer.parseInt(root);
                    term = atlas.getTerm(code);
                }
                catch (NumberFormatException nfe) {
                    throw new ParameterErrorException("malformedParameterValue", "root_code", root);
                }
                if (term == null) {
                    throw new ParameterErrorException("unknownParameterValue", "root_code", root);
                }
            } else {
                throw new ParameterErrorException("missingParameter", "root_uri|root_code");
            }
        }
        VentilationName ventilationName = JsonProducerFactory.getVentilationName(desmographie, "name", name);
        ConfLiaisonFilter confLiaisonFilter = new ConfLiaisonFilter(atlas, conf);
        InternalVentilationParameters ventilationParameters = new InternalVentilationParameters(atlas, term, confLiaisonFilter, conf, ventilationName);
        Ventilation ventilation = null;
        try {
            ventilation = ventilationFactory.getVentilation(ventilationParameters);
        }
        catch (UnsupportedVentilationNameException uvne) {
            throw new ParameterErrorException("unknownParameterValue", "name", name);
        }
        catch (UnsupportedVentilationRootException uvre) {
            throw new ParameterErrorException("unexpectedParameterValue", "root_uri|root_code", root);
        }
        double xyRatio = JsonProducerFactory.getXYRatio(requestMap);
        FaisceauAngulaire faisceau = null;
        if (xyRatio > 0.0) {
            faisceau = new FaisceauAngulaire(ventilation, 0.0, Math.PI * 2);
            faisceau.redim(new CartesianPoint(0, 0), xyRatio);
        }
        return new VentilationJsonProducer(ventilation, faisceau, rootFieldFilter, secteurFieldFilter, liaisonFieldFilter);
    }

    private static AbstractJsonProducer getStructureJsonProducer(RequestMap requestMap, Desmographie desmographie) {
        Atlas atlas = desmographie.getAtlas();
        FieldFilter fieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "");
        if (fieldFilter == null) {
            fieldFilter = FieldFilterBuilder.DEFAULT_FIELDFILTER;
        }
        return new StructureJsonProducer(atlas, fieldFilter);
    }

    private static AbstractJsonProducer getFamillesJsonProducer(RequestMap requestMap, Desmographie desmographie) {
        FieldFilter descripteurFieldFilter;
        FieldFilter familleFieldFilter;
        Atlas atlas = desmographie.getAtlas();
        FieldFilter defaultFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "");
        if (defaultFieldFilter == null) {
            defaultFieldFilter = FieldFilterBuilder.DEFAULT_FIELDFILTER;
        }
        if ((familleFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "_famille")) == null) {
            familleFieldFilter = defaultFieldFilter;
        }
        if ((descripteurFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "_descripteur")) == null) {
            descripteurFieldFilter = defaultFieldFilter;
        }
        FamilleSelection familleSelection = JsonProducerFactory.getFamilleSelection(requestMap, atlas);
        return new FamillesJsonProducer(atlas, familleSelection, familleFieldFilter, descripteurFieldFilter);
    }

    private static AbstractJsonProducer getLexieDistributionJsonProducer(RequestMap requestMap, Desmographie desmographie) {
        FieldFilter descripteurFieldFilter;
        Lang lang = JsonProducerFactory.getLang(requestMap);
        Atlas atlas = desmographie.getAtlas();
        FieldFilter defaultFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "");
        if (defaultFieldFilter == null) {
            defaultFieldFilter = FieldFilterBuilder.DEFAULT_FIELDFILTER;
        }
        if ((descripteurFieldFilter = JsonProducerFactory.getFieldFilter(requestMap, "_descripteur")) == null) {
            descripteurFieldFilter = defaultFieldFilter;
        }
        FamilleSelection familleSelection = JsonProducerFactory.getFamilleSelection(requestMap, atlas);
        return new LexieDistributionJsonProducer(atlas, lang, familleSelection, descripteurFieldFilter);
    }

    private static VentilationName getVentilationName(Desmographie desmographie, String parameter, String value) {
        VentilationName ventilationName;
        Atlas atlas = desmographie.getAtlas();
        if (value.equals("home")) {
            String homeVentilationNameString = desmographie.getSessionConf().getString("home.ventilationname");
            try {
                ventilationName = VentilationName.parse(homeVentilationNameString, atlas);
            }
            catch (ParseException pe) {
                throw new ParameterErrorException("wrongHomeValue", parameter, homeVentilationNameString);
            }
        }
        try {
            ventilationName = VentilationName.parse(value, atlas);
        }
        catch (ParseException pe) {
            throw new ParameterErrorException("malformedParameterValue", parameter, value);
        }
        return ventilationName;
    }

    private static String getMandatoryValue(RequestMap requestMap, String paramName) {
        String value = requestMap.getParameter(paramName);
        if (value == null) {
            throw new ParameterErrorException("missingParameter", paramName);
        }
        if (value.isEmpty()) {
            throw new ParameterErrorException("emptyParameter", paramName);
        }
        return value;
    }

    private static Lang getLang(RequestMap requestMap) {
        String langString = JsonProducerFactory.getMandatoryValue(requestMap, "lang");
        try {
            return Lang.parse((String)langString);
        }
        catch (ParseException pe) {
            throw new ParameterErrorException("malformedParameterValue", "lang");
        }
    }

    private static double getXYRatio(RequestMap requestMap) {
        String value = requestMap.getParameter("xyratio");
        if (value == null) {
            return 0.0;
        }
        if (value.isEmpty()) {
            return 1.0;
        }
        try {
            double d = Double.parseDouble(value);
            return d;
        }
        catch (NumberFormatException nfe) {
            throw new ParameterErrorException("malformedParameterValue", "xyratio");
        }
    }

    private static FieldFilter getFieldFilter(RequestMap requestMap, String paramSuffix) {
        String attrsParam;
        String fieldsParams = requestMap.getParameter("fields" + paramSuffix);
        if (fieldsParams == null) {
            return null;
        }
        FieldFilterBuilder fieldFilterBuilder = new FieldFilterBuilder();
        fieldFilterBuilder.parseFields(fieldsParams);
        if (fieldFilterBuilder.with(2) && (attrsParam = requestMap.getParameter("attrs" + paramSuffix)) != null) {
            fieldFilterBuilder.parseFields(attrsParam);
        }
        return fieldFilterBuilder.toFieldFilter();
    }

    private static FamilleSelection getFamilleSelection(RequestMap requestMap, Atlas atlas) {
        String selection_code;
        FamilleSelectionBuilder familleSelectionBuilder = new FamilleSelectionBuilder();
        if (requestMap.isTrue("sansfamille")) {
            familleSelectionBuilder.setWithSansfamille(true);
        }
        Grille grilleDesFamilles = atlas.getStructure().getGrilleDesFamilles();
        String selection_idctxt = requestMap.getParameter("selection_idctxt");
        if (selection_idctxt != null) {
            for (String token : StringUtils.getTokens((String)selection_idctxt, (char)',', (short)2)) {
                boolean recursive = false;
                boolean exclude = false;
                if (token.endsWith("@!")) {
                    token = token.substring(0, token.length() - 2).trim();
                    recursive = true;
                    exclude = true;
                } else if (token.endsWith("@")) {
                    token = token.substring(0, token.length() - 1).trim();
                    recursive = true;
                    exclude = false;
                }
                Contexte famille = grilleDesFamilles.getContexteByIdctxt(token);
                if (famille == null) continue;
                if (exclude) {
                    ContexteList children = famille.getChildren();
                    int childCount = children.getContexteCount();
                    for (int j = 0; j < childCount; ++j) {
                        familleSelectionBuilder.addFamille(children.getContexte(j), recursive);
                    }
                    continue;
                }
                familleSelectionBuilder.addFamille(famille, recursive);
            }
        }
        if ((selection_code = requestMap.getParameter("selection_code")) != null) {
            for (String token : StringUtils.getTokens((String)selection_code, (char)',', (short)2)) {
                boolean recursive = false;
                boolean exclude = false;
                if (token.endsWith("@!")) {
                    token = token.substring(0, token.length() - 2).trim();
                    recursive = true;
                    exclude = true;
                } else if (token.endsWith("@")) {
                    token = token.substring(0, token.length() - 1).trim();
                    recursive = true;
                    exclude = false;
                }
                try {
                    int code = Integer.parseInt(token);
                    Term term = atlas.getTerm(code);
                    if (term.getTermType() != 4) continue;
                    Contexte famille = (Contexte)term;
                    if (exclude) {
                        ContexteList children = famille.getChildren();
                        int childCount = children.getContexteCount();
                        for (int j = 0; j < childCount; ++j) {
                            familleSelectionBuilder.addFamille(children.getContexte(j), recursive);
                        }
                        continue;
                    }
                    familleSelectionBuilder.addFamille(famille, recursive);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return familleSelectionBuilder.toFamilleSelection();
    }

    private static class InternalVentilationParameters
    implements VentilationParameters {
        private final Term ventilationRoot;
        private final Atlas atlas;
        private final LiaisonFilter liaisonFilter;
        private final Conf sessionConf;
        private final VentilationName ventilationName;

        InternalVentilationParameters(Atlas atlas, Term ventilationRoot, LiaisonFilter liaisonFilter, Conf sessionConf, VentilationName ventilationName) {
            this.ventilationRoot = ventilationRoot;
            this.atlas = atlas;
            this.liaisonFilter = liaisonFilter;
            this.sessionConf = sessionConf;
            this.ventilationName = ventilationName;
        }

        @Override
        public Atlas getAtlas() {
            return this.atlas;
        }

        @Override
        public Term getVentilationRoot() {
            return this.ventilationRoot;
        }

        @Override
        public LiaisonFilter getLiaisonFilter() {
            return this.liaisonFilter;
        }

        @Override
        public Conf getSessionConf() {
            return this.sessionConf;
        }

        @Override
        public VentilationName getVentilationName() {
            return this.ventilationName;
        }
    }
}

