/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas.engines;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Lien;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.mapeadores.util.exceptions.ShouldNotOccurException;

public final class EngineUtils {
    private EngineUtils() {
    }

    public static boolean isPere(Croisement croisement) {
        for (Lien lien : croisement.getLienList()) {
            if (!lien.getMode().equals("pere")) continue;
            return true;
        }
        return false;
    }

    public static int isFils(Croisement croisement) {
        for (Lien lien : croisement.getLienList()) {
            if (!lien.getMode().equals("fils")) continue;
            return lien.getPoids();
        }
        return -1;
    }

    public static void setLienHierarchique(BdfAtlas bdfAtlas, FichothequeEditor fichothequeEditor, Motcle pere, Motcle contexte, Motcle fils) {
        EngineUtils.setLienHierarchique(fichothequeEditor, pere, contexte, fils, bdfAtlas.lienhierarchiqueCorpus, bdfAtlas.grilleThesaurus, bdfAtlas.descripteurThesaurus);
    }

    public static void setLienHierarchique(FichothequeEditor fichothequeEditor, Motcle pere, Motcle contexte, Motcle fils, Corpus lienhierarchiqueCorpus, Thesaurus grilleThesaurus, Thesaurus descripteurThesaurus) {
        FicheMeta ficheMeta;
        Fichotheque fichotheque = fichothequeEditor.getFichotheque();
        Croisements lienCroisements = fichotheque.getCroisements((SubsetItem)pere, (Subset)lienhierarchiqueCorpus);
        FicheMeta lienhierarchique = null;
        block3: for (Croisements.Entry lienEntry : lienCroisements.getEntryList()) {
            ficheMeta = (FicheMeta)lienEntry.getSubsetItem();
            if (!EngineUtils.isPere(lienEntry.getCroisement())) continue;
            Croisements contexteCroisements = fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)grilleThesaurus);
            for (Croisements.Entry contexteEntry : contexteCroisements.getEntryList()) {
                if (!contexteEntry.getSubsetItem().equals(contexte)) continue;
                lienhierarchique = ficheMeta;
                continue block3;
            }
        }
        CroisementEditor croisementEditor = fichothequeEditor.getCroisementEditor();
        if (lienhierarchique == null) {
            CorpusEditor corpusEditor = fichothequeEditor.getCorpusEditor(lienhierarchiqueCorpus);
            try {
                ficheMeta = corpusEditor.createFiche(-1);
            }
            catch (ExistingIdException eie) {
                throw new ShouldNotOccurException("Test done before");
            }
            catch (NoMasterIdException nmie) {
                throw new ShouldNotOccurException("Not a satellite subset");
            }
            CroisementChangeEngine engine = CroisementChangeEngine.clearExistingEngine((SubsetItem)ficheMeta);
            engine.addLien((SubsetItem)pere, "pere", 1);
            engine.addLien((SubsetItem)contexte, "", 1);
            engine.addLien((SubsetItem)fils, "fils", 1);
            croisementEditor.updateCroisements((SubsetItem)ficheMeta, engine.toCroisementChanges());
            corpusEditor.saveFiche(ficheMeta, (FicheAPI)new Fiche());
        } else {
            Croisements currentFilsCroisements = fichotheque.getCroisements(lienhierarchique, (Subset)descripteurThesaurus);
            boolean existing = false;
            int poidsMax = 0;
            for (Croisements.Entry currentFilsEntry : currentFilsCroisements.getEntryList()) {
                Croisement croisement = currentFilsEntry.getCroisement();
                Lien bdfLien = croisement.getLienByMode("fils");
                if (bdfLien == null) continue;
                if (currentFilsEntry.getSubsetItem().equals(fils)) {
                    existing = true;
                    break;
                }
                poidsMax = Math.max(poidsMax, bdfLien.getPoids());
            }
            if (!existing) {
                CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendEngine(lienhierarchique);
                croisementChangeEngine.addLien((SubsetItem)fils, "fils", poidsMax + 1);
                croisementEditor.updateCroisements((SubsetItem)lienhierarchique, croisementChangeEngine.toCroisementChanges());
            }
        }
    }

    public static Motcle getContexteMotcle(FicheMeta lienhierarchique, BdfAtlas bdfAtlas) {
        Croisements contexteCroisements = lienhierarchique.getFichotheque().getCroisements((SubsetItem)lienhierarchique, (Subset)bdfAtlas.grilleThesaurus);
        return (Motcle)contexteCroisements.getFirstSubsetItem();
    }
}

