/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas.engines;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfext.desmoservice.atlas.engines.EngineUtils;
import java.util.ArrayList;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.mapeadores.util.localisation.Langs;

class DescripteursMergeEngine {
    private final BdfAtlas bdfAtlas;
    private final Fichotheque fichotheque;
    private final FichothequeEditor fichothequeEditor;
    private final CroisementEditor croisementEditor;
    private final Motcle destinationDescripteur;
    private final Set<Motcle> originSet;
    private final Langs langs;

    DescripteursMergeEngine(BdfAtlas bdfAtlas, FichothequeEditor fichothequeEditor, Motcle destinationDescripteur, Set<Motcle> originSet, Langs langs) {
        this.bdfAtlas = bdfAtlas;
        this.fichothequeEditor = fichothequeEditor;
        this.fichotheque = fichothequeEditor.getFichotheque();
        this.croisementEditor = fichothequeEditor.getCroisementEditor();
        this.destinationDescripteur = destinationDescripteur;
        this.originSet = originSet;
        this.langs = langs;
    }

    void run() {
        this.cleanFils(this.destinationDescripteur);
        for (Motcle originDescripteur : this.originSet) {
            this.cleanFils(originDescripteur);
        }
        for (Motcle originDescripteur : this.originSet) {
            this.moveLienhierarchique(originDescripteur);
            try {
                ThesaurusTools.merge((FichothequeEditor)this.fichothequeEditor, (Motcle)originDescripteur, (Motcle)this.destinationDescripteur, (Langs)this.langs);
            }
            catch (ParentRecursivityException pre) {
                throw new IllegalStateException("destinationDescripteur is child of origin descripteur");
            }
        }
    }

    private void cleanFils(Motcle descripteur) {
        ArrayList<Motcle> removeList = new ArrayList<Motcle>();
        ArrayList<FicheMeta> lienRemoveList = new ArrayList<FicheMeta>();
        Croisements lienCroisements = this.fichotheque.getCroisements((SubsetItem)descripteur, (Subset)this.bdfAtlas.lienhierarchiqueCorpus);
        for (Croisements.Entry lienEntry : lienCroisements.getEntryList()) {
            Croisement croisement = lienEntry.getCroisement();
            boolean pere = EngineUtils.isPere(croisement);
            int fils = EngineUtils.isFils(croisement);
            if (!pere && fils == -1) continue;
            FicheMeta lienhierarchique = (FicheMeta)lienEntry.getSubsetItem();
            Croisements otherCroisements = this.fichotheque.getCroisements((SubsetItem)lienhierarchique, (Subset)this.bdfAtlas.descripteurThesaurus);
            boolean originIsDescripteurPere = false;
            for (Croisements.Entry otherEntry : otherCroisements.getEntryList()) {
                Motcle otherDescripteur = (Motcle)otherEntry.getSubsetItem();
                if (otherDescripteur.equals(descripteur) || !this.originSet.contains(otherDescripteur)) continue;
                if (EngineUtils.isFils(otherEntry.getCroisement()) != -1) {
                    removeList.add(otherDescripteur);
                }
                if (!EngineUtils.isPere(otherEntry.getCroisement())) continue;
                originIsDescripteurPere = true;
            }
            for (Motcle otherDescripteur : removeList) {
                this.croisementEditor.updateCroisement((SubsetItem)lienhierarchique, (SubsetItem)otherDescripteur, BdfAtlasUtils.FILSREMOVE_CROISEMENTCHANGE);
            }
            removeList.clear();
            if (fils == -1 || !originIsDescripteurPere) continue;
            lienRemoveList.add(lienhierarchique);
        }
        for (FicheMeta lienhierarchique : lienRemoveList) {
            this.croisementEditor.updateCroisement((SubsetItem)lienhierarchique, (SubsetItem)descripteur, BdfAtlasUtils.FILSREMOVE_CROISEMENTCHANGE);
        }
    }

    private void moveLienhierarchique(Motcle descripteur) {
        Croisements lienCroisements = this.fichotheque.getCroisements((SubsetItem)descripteur, (Subset)this.bdfAtlas.lienhierarchiqueCorpus);
        ArrayList<FicheMeta> removeList = new ArrayList<FicheMeta>();
        for (Croisements.Entry lienEntry : lienCroisements.getEntryList()) {
            Croisement croisement = lienEntry.getCroisement();
            boolean pere = EngineUtils.isPere(croisement);
            int fils = EngineUtils.isFils(croisement);
            if (!pere && fils == -1) continue;
            FicheMeta lienhierarchique = (FicheMeta)lienEntry.getSubsetItem();
            Motcle contexte = EngineUtils.getContexteMotcle(lienhierarchique, this.bdfAtlas);
            if (pere) {
                Croisements otherCroisements = this.fichotheque.getCroisements((SubsetItem)lienhierarchique, (Subset)this.bdfAtlas.descripteurThesaurus);
                for (Croisements.Entry otherEntry : otherCroisements.getEntryList()) {
                    Motcle otherDescripteur = (Motcle)otherEntry.getSubsetItem();
                    EngineUtils.setLienHierarchique(this.bdfAtlas, this.fichothequeEditor, this.destinationDescripteur, contexte, otherDescripteur);
                }
                removeList.add(lienhierarchique);
                continue;
            }
            CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendEngine((SubsetItem)lienhierarchique);
            croisementChangeEngine.addLien((SubsetItem)this.destinationDescripteur, "fils", fils);
            this.croisementEditor.updateCroisements((SubsetItem)lienhierarchique, croisementChangeEngine.toCroisementChanges());
        }
        for (FicheMeta lienhierarchique : removeList) {
            FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (FicheMeta)lienhierarchique);
        }
    }
}

