/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasMetadata;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfext.desmoservice.atlas.BdfContexte;
import fr.exemole.bdfext.desmoservice.atlas.BdfDescripteur;
import fr.exemole.bdfext.desmoservice.atlas.BdfDescripteurs;
import fr.exemole.bdfext.desmoservice.atlas.BdfGrille;
import fr.exemole.bdfext.desmoservice.atlas.BdfLiens;
import fr.exemole.bdfext.desmoservice.atlas.BdfStructure;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.event.AttributeListener;
import net.desmodo.atlas.event.CompoundAtlasEventListener;
import net.desmodo.atlas.event.LabelListener;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.metadata.AtlasMetadata;
import net.desmodo.atlas.session.SessionConf;
import net.desmodo.atlas.structure.Structure;
import net.fichotheque.Fichotheque;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.pointeurs.PointeurFactory;

public class BdfAtlas
implements Atlas {
    public static final String PERE_MODE = "pere";
    public static final String FILS_MODE = "fils";
    public static final String FAMILLE_MODE = "";
    public String atlasPrefix;
    public Fichotheque fichotheque;
    public Motcle atlasMotcle;
    public Thesaurus familleThesaurus;
    public Thesaurus grilleThesaurus;
    public Thesaurus descripteurThesaurus;
    public Corpus lienhierarchiqueCorpus;
    FichePointeur atlasFichePointeur;
    FieldKey paramsFieldKey;
    private BdfStructure bdfStructure;
    private BdfDescripteurs bdfDescripteurs;
    private BdfLiens bdfLiens;
    private BdfAtlasMetadata bdfAtlasMetadata;
    private SessionConf defaultSessionConf;
    private final Map<Integer, Term> termMap = new ConcurrentHashMap<Integer, Term>();

    private BdfAtlas() {
    }

    private void init(AliasHolder coreAliasHolder, Motcle atlasMotcle) {
        this.atlasMotcle = atlasMotcle;
        this.fichotheque = atlasMotcle.getFichotheque();
        this.atlasPrefix = atlasMotcle.getIdalpha() + "/";
        this.familleThesaurus = coreAliasHolder.getThesaurus("famille");
        this.grilleThesaurus = coreAliasHolder.getThesaurus("grille");
        this.descripteurThesaurus = coreAliasHolder.getThesaurus("descripteur");
        this.lienhierarchiqueCorpus = coreAliasHolder.getCorpus("lienhierarchique");
        this.paramsFieldKey = coreAliasHolder.getCorpusField("atlas_params").getFieldKey();
        Corpus atlasCorpus = coreAliasHolder.getCorpus("atlas");
        this.atlasFichePointeur = PointeurFactory.newFichePointeur((Corpus)atlasCorpus);
        this.atlasFichePointeur.setCurrentSubsetItem(atlasMotcle.getId());
        this.bdfAtlasMetadata = BdfAtlasMetadata.init(this, atlasMotcle, coreAliasHolder);
    }

    public static BdfAtlas newInstance(AliasHolder coreAliasHolder, Motcle atlasMotcle) {
        BdfAtlas bdfAtlas = new BdfAtlas();
        bdfAtlas.init(coreAliasHolder, atlasMotcle);
        return bdfAtlas;
    }

    public synchronized SessionConf getDefaultSessionConf() {
        if (this.defaultSessionConf == null) {
            SessionConf sessionConf = new SessionConf();
            FicheItems ficheItems = (FicheItems)this.atlasFichePointeur.getValue(this.paramsFieldKey);
            if (ficheItems != null) {
                for (FicheItem ficheItem : ficheItems) {
                    String val;
                    int idx;
                    if (!(ficheItem instanceof Item) || (idx = (val = ((Item)ficheItem).getValue()).indexOf(61)) == -1) continue;
                    sessionConf.set(val.substring(0, idx).trim(), val.substring(idx + 1).trim());
                }
            }
            this.defaultSessionConf = sessionConf;
        }
        return this.defaultSessionConf;
    }

    @Override
    public synchronized Structure getStructure() {
        if (this.bdfStructure == null) {
            this.bdfStructure = new BdfStructure(this);
        }
        return this.bdfStructure;
    }

    @Override
    public synchronized Liens getLiens() {
        if (this.bdfLiens == null) {
            this.bdfLiens = new BdfLiens(this);
        }
        return this.bdfLiens;
    }

    @Override
    public AtlasMetadata getAtlasMetadata() {
        return this.bdfAtlasMetadata;
    }

    @Override
    public synchronized Descripteurs getDescripteurs() {
        if (this.bdfDescripteurs == null) {
            this.bdfDescripteurs = new BdfDescripteurs(this);
        }
        return this.bdfDescripteurs;
    }

    @Override
    public Term getTerm(int code) {
        Term terme = this.termMap.get(code);
        if (terme != null) {
            return terme;
        }
        if (code == 5) {
            terme = this.getStructure().getSpecialContexte((short)5);
            this.termMap.put(code, terme);
        } else if (code == 5) {
            terme = this.getStructure().getSpecialContexte((short)5);
            this.termMap.put(code, terme);
        } else if (code == 8) {
            terme = this.bdfAtlasMetadata.getTitre();
            this.termMap.put(code, terme);
        } else {
            short type = BdfAtlasUtils.getTypeFromTermCode(code);
            int id = BdfAtlasUtils.getIdFromTermCode(code);
            switch (type) {
                case 4: {
                    Motcle famille = this.familleThesaurus.getMotcleById(id);
                    if (famille == null || famille.getParent() == null || !this.testGrilleOrContexteAppartenance(famille)) break;
                    terme = this.getBdfContexte(famille);
                    break;
                }
                case 3: {
                    Motcle contexte = this.grilleThesaurus.getMotcleById(id);
                    if (contexte == null || contexte.getParent() == null || !this.testGrilleOrContexteAppartenance(contexte)) break;
                    terme = this.getBdfContexte(contexte);
                    break;
                }
                case 2: {
                    Motcle grille = this.grilleThesaurus.getMotcleById(id);
                    if (grille == null || grille.getParent() != null) break;
                    terme = this.getBdfContexte(grille);
                    break;
                }
                case 7: {
                    Motcle familles = this.familleThesaurus.getMotcleById(id);
                    if (familles == null || familles.getParent() != null) break;
                    terme = this.getBdfContexte(familles);
                    break;
                }
                case 1: {
                    Motcle descripteur = this.descripteurThesaurus.getMotcleById(id);
                    if (descripteur == null) break;
                    terme = this.getBdfDescripteur(descripteur);
                }
            }
        }
        return terme;
    }

    public Motcle getMotcle(short type, int id) {
        switch (type) {
            case 4: {
                Motcle famille = this.familleThesaurus.getMotcleById(id);
                if (famille == null) {
                    return null;
                }
                if (famille.getParent() == null) {
                    return null;
                }
                if (!this.testGrilleOrContexteAppartenance(famille)) {
                    return null;
                }
                return famille;
            }
            case 3: {
                Motcle contexte = this.grilleThesaurus.getMotcleById(id);
                if (contexte == null) {
                    return null;
                }
                if (contexte.getParent() == null) {
                    return null;
                }
                if (!this.testGrilleOrContexteAppartenance(contexte)) {
                    return null;
                }
                return contexte;
            }
            case 2: {
                Motcle grille = this.grilleThesaurus.getMotcleById(id);
                if (grille == null) {
                    return null;
                }
                if (grille.getParent() != null) {
                    return null;
                }
                if (!this.testGrilleOrContexteAppartenance(grille)) {
                    return null;
                }
                return grille;
            }
            case 7: {
                Motcle familles = this.familleThesaurus.getMotcleById(id);
                if (familles == null) {
                    return null;
                }
                if (familles.getParent() != null) {
                    return null;
                }
                if (!this.testGrilleOrContexteAppartenance(familles)) {
                    return null;
                }
                return familles;
            }
            case 1: {
                Motcle descripteur = this.descripteurThesaurus.getMotcleById(id);
                if (descripteur == null) {
                    return null;
                }
                if (!this.testDescripteurAppartenance(descripteur)) {
                    return null;
                }
                return descripteur;
            }
        }
        return null;
    }

    @Override
    public void addCompoundAtlasEventListener(CompoundAtlasEventListener compoundAtlasEventListener) {
    }

    @Override
    public void removeCompoundAtlasEventListener(CompoundAtlasEventListener compoundAtlasEventListener) {
    }

    @Override
    public void addAttributeListener(AttributeListener attributeListener) {
    }

    @Override
    public void removeAttributeListener(AttributeListener attributeListener) {
    }

    @Override
    public void addLibelleListener(LabelListener libelleListener) {
    }

    @Override
    public void removeLibelleListener(LabelListener libelleListener) {
    }

    synchronized BdfContexte getBdfContexte(Motcle motcle) {
        short type = this.getContexteType(motcle);
        int code = BdfAtlasUtils.getTermCode(motcle, type);
        Term term = this.termMap.get(code);
        if (term != null) {
            return (BdfContexte)term;
        }
        if (!this.testGrilleOrContexteAppartenance(motcle)) {
            return null;
        }
        BdfContexte bdfContexte = new BdfContexte(this, motcle, type, code);
        this.termMap.put(code, bdfContexte);
        return bdfContexte;
    }

    synchronized BdfGrille getBdfGrille(Motcle motcle) {
        short type = this.getGrilleType(motcle);
        int code = BdfAtlasUtils.getTermCode(motcle, type);
        Term term = this.termMap.get(code);
        if (term != null) {
            return (BdfGrille)term;
        }
        if (!this.testGrilleOrContexteAppartenance(motcle)) {
            return null;
        }
        BdfGrille bdfContexte = new BdfGrille(this, motcle, type, code);
        this.termMap.put(code, bdfContexte);
        return bdfContexte;
    }

    synchronized BdfDescripteur getBdfDescripteur(Motcle motcle) {
        int code = BdfAtlasUtils.getTermCode(motcle, (short)1);
        Term term = this.termMap.get(code);
        if (term != null) {
            return (BdfDescripteur)term;
        }
        if (!this.testDescripteurAppartenance(motcle)) {
            return null;
        }
        BdfDescripteur bdfDescripteur = new BdfDescripteur(this, motcle, code);
        this.termMap.put(code, bdfDescripteur);
        return bdfDescripteur;
    }

    BdfContexte getContexteByIdctxt(short grilleType, String idctxt, String grilleIdalpha) {
        Thesaurus thesaurus;
        String idalpha = grilleIdalpha + "/" + idctxt;
        switch (grilleType) {
            case 2: {
                thesaurus = this.grilleThesaurus;
                break;
            }
            case 7: {
                thesaurus = this.familleThesaurus;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong type = " + grilleType);
            }
        }
        Motcle motcle = thesaurus.getMotcleByIdalpha(idalpha);
        if (motcle == null) {
            return null;
        }
        if (motcle.getParent() == null) {
            return null;
        }
        return this.getBdfContexte(motcle);
    }

    BdfGrille getGrille(String grilleName) {
        String idalpha;
        Motcle motcle;
        if (grilleName.isEmpty()) {
            this.getStructure().getGrilleDesFamilles();
        }
        if ((motcle = this.grilleThesaurus.getMotcleByIdalpha(idalpha = this.atlasPrefix + grilleName)) == null) {
            return null;
        }
        if (motcle.getParent() != null) {
            return null;
        }
        return this.getBdfGrille(motcle);
    }

    BdfDescripteur getDescripteurByIddesc(Iddesc iddesc) {
        String idalpha = this.atlasPrefix + iddesc.toString();
        Motcle motcle = this.descripteurThesaurus.getMotcleByIdalpha(idalpha);
        if (motcle == null) {
            return null;
        }
        return this.getBdfDescripteur(motcle);
    }

    private short getContexteType(Motcle motcle) {
        Thesaurus thesaurus = motcle.getThesaurus();
        if (thesaurus.equals(this.familleThesaurus)) {
            return 4;
        }
        if (thesaurus.equals(this.grilleThesaurus)) {
            return 3;
        }
        throw new IllegalArgumentException("Motcle doit appartenir \u00e0 familleThesaurus ou grilleThesaurus");
    }

    private short getGrilleType(Motcle motcle) {
        Thesaurus thesaurus = motcle.getThesaurus();
        if (thesaurus.equals(this.familleThesaurus)) {
            return 7;
        }
        if (thesaurus.equals(this.grilleThesaurus)) {
            return 2;
        }
        throw new IllegalArgumentException("Motcle doit appartenir \u00e0 familleThesaurus ou grilleThesaurus");
    }

    boolean testDescripteurAppartenance(Motcle motcle) {
        String idalpha = motcle.getIdalpha();
        return idalpha.startsWith(this.atlasPrefix);
    }

    boolean testGrilleOrContexteAppartenance(Motcle motcle) {
        String idalpha = motcle.getIdalpha();
        if (motcle.getThesaurus().equals(this.familleThesaurus) && motcle.getLevel() == 1) {
            return idalpha.equals(this.atlasMotcle.getIdalpha());
        }
        return idalpha.startsWith(this.atlasPrefix);
    }

    boolean isValidContexte(Motcle motcle) {
        if (!this.testGrilleOrContexteAppartenance(motcle)) {
            return false;
        }
        return motcle.getParent() != null;
    }
}

