/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice;

import fr.exemole.bdfext.desmoservice.DesmoserviceUtils;
import fr.exemole.bdfext.desmoservice.api.AtlasEdition;
import fr.exemole.bdfext.desmoservice.api.Desmographie;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.engines.BdfAtlasEditionEngine;
import fr.exemole.bdfext.desmoservice.atlas.export.DsmdXmlProducer;
import fr.exemole.bdfext.desmoservice.edition.AtlasEditionBuilder;
import fr.exemole.bdfext.desmoservice.edition.AtlasEditionDOMReader;
import fr.exemole.bdfext.desmoservice.json.JsonProducerFactory;
import fr.exemole.bdfext.desmoservice.json.ParameterErrorException;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.providers.BdfInstructionProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasFilter;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.conf.StringMapConf;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.json.producers.ErrorJsonProducer;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.MessageLog;
import net.mapeadores.util.logging.MessageLogBuilder;
import net.mapeadores.util.primitives.RangeUtils;
import net.mapeadores.util.primitives.Ranges;
import net.mapeadores.util.regex.RegexList;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.script.ScriptFamily;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.XmlResponseHandler;
import net.mapeadores.util.text.LangFilter;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XmlProducer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DesmoserviceBdfInstructionProvider
implements BdfInstructionProvider {
    private static final RegexList regexList;
    private final DesmoserviceContext desmoserviceContext;

    public DesmoserviceBdfInstructionProvider(DesmoserviceContext desmoserviceContext) {
        this.desmoserviceContext = desmoserviceContext;
    }

    public BdfInstruction getBdfInstruction(BdfServer bdfServer, String extensionPath, RequestMap requestMap) {
        if (this.desmoserviceContext.getInitState() != 1) {
            return null;
        }
        Map map = regexList.getMap(extensionPath);
        if (map == null) {
            return null;
        }
        String type = (String)map.get("type");
        if (type.equals("json")) {
            return new JsonBdfInstruction(bdfServer, this.desmoserviceContext, requestMap);
        }
        if (type.equals("export")) {
            Lang lang;
            String name = (String)map.get("name");
            if (name == null) {
                return null;
            }
            String langString = (String)map.get("lang");
            if (langString == null) {
                return null;
            }
            try {
                lang = Lang.parse((String)langString);
            }
            catch (ParseException pe) {
                return null;
            }
            Desmographie desmographie = this.desmoserviceContext.getDesmoserviceCache().getDesmographie(name);
            if (desmographie == null) {
                return null;
            }
            return new ExportBdfInstruction(desmographie, requestMap, lang, this.desmoserviceContext);
        }
        if (type.equals("edition")) {
            return new EditionBdfInstruction(bdfServer, this.desmoserviceContext, requestMap);
        }
        return null;
    }

    private static String getMandatoryValue(RequestMap requestMap, String paramName) {
        String value = requestMap.getParameter(paramName);
        if (value == null) {
            throw new ParameterErrorException("missingParameter", paramName);
        }
        if (value.isEmpty()) {
            throw new ParameterErrorException("emptyParameter", paramName);
        }
        return value;
    }

    static {
        try {
            String s = IOUtils.toString((InputStream)DesmoserviceBdfInstructionProvider.class.getResourceAsStream("regex.txt"), (String)"UTF-8");
            regexList = RegexList.parse((String)s);
        }
        catch (IOException ioe) {
            throw new InternalResourceException((Exception)ioe);
        }
    }

    private static class JsonBdfInstruction
    implements BdfInstruction,
    BdfInstructionConstants {
        private final BdfServer bdfServer;
        private final RequestMap requestMap;
        private final DesmoserviceContext desmoserviceContext;

        private JsonBdfInstruction(BdfServer bdfServer, DesmoserviceContext desmoserviceContext, RequestMap requestMap) {
            this.bdfServer = bdfServer;
            this.requestMap = requestMap;
            this.desmoserviceContext = desmoserviceContext;
        }

        public short getBdfUserNeed() {
            return 1;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            JsonProducer jsonProducer = JsonProducerFactory.getJsonProducer(this.bdfServer, this.desmoserviceContext, this.requestMap);
            return JsonResponseHandler.build((JsonProducer)jsonProducer, (RequestMap)this.requestMap);
        }
    }

    private static class ExportBdfInstruction
    implements BdfInstruction,
    BdfInstructionConstants {
        private final Desmographie desmographie;
        private final RequestMap requestMap;
        private final Lang lang;
        private final DesmoserviceContext desmoserviceContext;

        private ExportBdfInstruction(Desmographie desmographie, RequestMap requestMap, Lang lang, DesmoserviceContext desmoserviceContext) {
            this.desmographie = desmographie;
            this.requestMap = requestMap;
            this.lang = lang;
            this.desmoserviceContext = desmoserviceContext;
        }

        public short getBdfUserNeed() {
            return 1;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            Ranges ranges;
            String mode = this.requestMap.getParameter("mode");
            String descRange = this.requestMap.getParameter("desc-range");
            AtlasFilter atlasFilter = mode != null && mode.equals("modele") ? AtlasUtils.ONLYSTRUCTURE_ATLASFILTER : (descRange != null ? ((ranges = RangeUtils.positiveRangeParse((String)descRange)) != null ? new RangeListAtlasFilter(ranges) : AtlasUtils.ACCEPTALL_ATLASFILTER) : AtlasUtils.ACCEPTALL_ATLASFILTER);
            String script = this.requestMap.getParameter("script");
            ScriptFamily scriptFamily = null;
            if (script != null) {
                scriptFamily = this.desmoserviceContext.getScriptFamilyProvider().getScriptFamily(script);
            }
            Atlas atlas = this.desmographie.getAtlas();
            StringMapConf conf = DesmoserviceUtils.checkConf(this.requestMap, this.desmographie.getSessionConf());
            conf.put("lang.current", this.lang.toString());
            return XmlResponseHandler.init((XmlProducer)new DsmdXmlProducer(atlas, conf, atlasFilter, scriptFamily), (String)"application/x-desmodo");
        }
    }

    private static class EditionBdfInstruction
    implements BdfInstruction,
    BdfInstructionConstants {
        private final BdfServer bdfServer;
        private final RequestMap requestMap;
        private final DesmoserviceContext desmoserviceContext;

        private EditionBdfInstruction(BdfServer bdfServer, DesmoserviceContext desmoserviceContext, RequestMap requestMap) {
            this.bdfServer = bdfServer;
            this.requestMap = requestMap;
            this.desmoserviceContext = desmoserviceContext;
        }

        public short getBdfUserNeed() {
            return 1;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            JsonProducer jsonProducer;
            try {
                jsonProducer = this.runInstruction();
            }
            catch (ParameterErrorException pee) {
                jsonProducer = new ErrorJsonProducer(pee.getErrorKey(), pee.getParameter(), pee.getValue());
            }
            return JsonResponseHandler.build((JsonProducer)jsonProducer, (RequestMap)this.requestMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JsonProducer runInstruction() {
            Document document;
            String desmo = DesmoserviceBdfInstructionProvider.getMandatoryValue(this.requestMap, "desmo");
            String xml = DesmoserviceBdfInstructionProvider.getMandatoryValue(this.requestMap, "xml");
            Desmographie desmographie = this.desmoserviceContext.getDesmoserviceCache().getDesmographie(desmo);
            if (desmographie == null) {
                throw new ParameterErrorException("unknownParameterValue", "desmo", desmo);
            }
            DocumentBuilder documentBuilder = DOMUtils.newDocumentBuilder();
            try {
                document = documentBuilder.parse(new InputSource(new StringReader(xml)));
            }
            catch (SAXException saxe) {
                throw new ParameterErrorException("malformedParameterValue", "xml", saxe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException();
            }
            MessageLogBuilder logBuilder = new MessageLogBuilder();
            EditionJsonProducer editionJsonProducer = new EditionJsonProducer();
            AtlasEditionBuilder atlasEditionBuilder = new AtlasEditionBuilder();
            logBuilder.setCurrentSource("XmlParse");
            AtlasEditionDOMReader atlasEditionDOMReader = new AtlasEditionDOMReader(atlasEditionBuilder, desmographie.getAtlas(), (MessageHandler)logBuilder);
            atlasEditionDOMReader.fillAtlasEdition(document.getDocumentElement());
            AtlasEdition atlasEdition = atlasEditionBuilder.toAtlasEdition();
            BdfServer bdfServer = this.bdfServer;
            synchronized (bdfServer) {
                try (EditSession editSession = this.bdfServer.initEditSession("ext:Desmoservice");){
                    logBuilder.setCurrentSource("EditionEngine");
                    BdfAtlasEditionEngine engine = new BdfAtlasEditionEngine((BdfAtlas)desmographie.getAtlas(), this.bdfServer, editSession.getFichothequeEditor(), (MessageHandler)logBuilder);
                    engine.runEdition(atlasEdition);
                }
            }
            editionJsonProducer.messageLog = logBuilder.toMessageLog();
            return editionJsonProducer;
        }
    }

    private static class RangeListAtlasFilter
    implements AtlasFilter {
        private final Ranges ranges;

        private RangeListAtlasFilter(Ranges ranges) {
            this.ranges = ranges;
        }

        @Override
        public boolean onlyStructure() {
            return false;
        }

        @Override
        public LangFilter getLangFilter() {
            return AtlasUtils.ACCEPTALL_LANGFILTER;
        }

        @Override
        public boolean acceptDescripteur(Descripteur descripteur) {
            return this.ranges.contains(descripteur.getCode());
        }
    }

    private static class EditionJsonProducer
    implements JsonProducer {
        private String message;
        private MessageLog messageLog = null;

        private EditionJsonProducer() {
        }

        public void writeJson(Appendable appendable) throws IOException {
            JSONWriter jsonWriter = new JSONWriter(appendable);
            jsonWriter.object();
            jsonWriter.key("message");
            jsonWriter.value((Object)"R\u00e9ussi !");
            if (this.messageLog != null) {
                jsonWriter.key("log");
                jsonWriter.value((Object)LogUtils.toString((MessageLog)this.messageLog));
            }
            jsonWriter.endObject();
        }
    }
}

