/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.sync.xml;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class RelationsXMLPart
extends XMLPart {
    public RelationsXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public RelationsXMLPart addRelations(Atlas atlas) throws IOException {
        this.openTag("relations");
        for (FicheMeta ficheMeta : atlas.getRelationCorpus().getFicheMetaList()) {
            this.addRelation(atlas, ficheMeta);
        }
        this.closeTag("relations");
        return this;
    }

    private void addRelation(Atlas atlas, FicheMeta ficheMeta) throws IOException {
        this.startOpenTag("relation").addAttribute("id", ficheMeta.getId()).addAttribute("type", AtlasUtils.getRelationType(ficheMeta)).endOpenTag();
        this.addMode(AtlasUtils.superiors(atlas, ficheMeta), "superior");
        this.addMode(AtlasUtils.inferiors(atlas, ficheMeta), "inferior");
        this.addMode(AtlasUtils.sectors(atlas, ficheMeta), "sector");
        this.closeTag("relation");
    }

    private void addMode(List<Motcle> motcleList, String tagName) throws IOException {
        for (Motcle motcle : motcleList) {
            this.addSimpleElement(tagName, motcle.getIdalpha());
        }
    }

    public static RelationsXMLPart init(XMLWriter xmlWriter) {
        return new RelationsXMLPart(xmlWriter);
    }
}

