/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json.api;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.IndexationItem;
import fr.exemole.bdfext.desmography.json.Extract;
import fr.exemole.bdfext.desmography.json.ResourceJson;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.include.IncludeMode;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;

public class ResourcesJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Set<SubsetItem> itemSet;
    private final Lang lang;
    private final boolean withIndexation;
    private final CellConverter propertiesCellConverter;

    public ResourcesJsonProducer(Atlas atlas, Set<SubsetItem> itemSet, Lang lang, boolean withIndexation, CellConverter propertiesCellConverter) {
        this.atlas = atlas;
        this.itemSet = itemSet;
        this.lang = lang;
        this.withIndexation = withIndexation;
        this.propertiesCellConverter = propertiesCellConverter;
    }

    public void writeJson(Appendable appendable) throws IOException {
        Thesaurus termThesaurus = this.atlas.getTermThesaurus();
        Fichotheque fichotheque = termThesaurus.getFichotheque();
        Extract extract = new Extract();
        ArrayList<Integer> refList = new ArrayList<Integer>();
        for (SubsetItem resource : this.itemSet) {
            refList.add(extract.addResource(resource));
        }
        if (this.withIndexation) {
            for (SubsetItem resource : this.itemSet) {
                IndexationItem indexationItem = this.atlas.getIndexationItemMap().get(resource.getSubsetKey());
                LinkedHashMap<IncludeKey, List<Integer>> indexationMap = new LinkedHashMap<IncludeKey, List<Integer>>();
                if (indexationItem != null) {
                    Croisements croisements = fichotheque.getCroisements(resource, (Subset)this.atlas.getTermThesaurus());
                    for (IncludeKey includeKey : indexationItem.getTermInOtherSubsetIncludeKeySet()) {
                        Collection liaisons = CroisementUtils.filter((Croisements)croisements, (IncludeMode)includeKey);
                        if (liaisons.isEmpty()) continue;
                        ArrayList<Integer> termIndexList = new ArrayList<Integer>();
                        for (Liaison liaison : liaisons) {
                            termIndexList.add(extract.addTerm((Motcle)liaison.getSubsetItem()));
                        }
                        indexationMap.put(includeKey, termIndexList);
                    }
                }
                extract.putIndexationMap(resource, indexationMap);
            }
        }
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("resource_refs");
        jw.array();
        for (Integer resourceIndex : refList) {
            jw.value((Object)resourceIndex);
        }
        jw.endArray();
        if (this.withIndexation) {
            TermJson.properties(jw, this.atlas, extract, this.lang, true);
        }
        ResourceJson.properties(jw, this.atlas, extract, this.lang, this.propertiesCellConverter, null);
        this.writeWarnings(jw);
        jw.endObject();
    }
}

