/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json.api;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasIOLoops;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.io.IOConsumer;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;

public class FamiliesJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Lang lang;

    public FamiliesJsonProducer(Atlas atlas, Lang lang) {
        this.atlas = atlas;
        this.lang = lang;
    }

    public void writeJson(Appendable appendable) throws IOException {
        List<Motcle> rootList = AtlasUtils.getRootFamiliesList(this.atlas);
        HashSet<Motcle> usedTermSet = new HashSet<Motcle>(rootList);
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("families");
        jw.array();
        for (Motcle term : rootList) {
            this.writeTerm(jw, term, usedTermSet);
        }
        jw.endArray();
        this.writeWarnings(jw);
        jw.endObject();
    }

    private void writeTerm(JSONWriter jw, Motcle term, Set<Motcle> usedTermSet) throws IOException {
        jw.object();
        TermJson.dataProperties(jw, this.atlas, term, this.lang);
        TermJson.rosetteProperty(jw, term.getAttributes());
        jw.key("subfamilies");
        jw.array();
        AtlasIOLoops.forEachSubfamily(this.atlas, term, (IOConsumer<Motcle>)((IOConsumer)subfamily -> {
            if (!usedTermSet.contains(subfamily)) {
                usedTermSet.add((Motcle)subfamily);
                this.writeTerm(jw, (Motcle)subfamily, usedTermSet);
            }
        }));
        jw.endArray();
        jw.endObject();
    }
}

