/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.engines.AtlasEditionReport;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import java.util.Set;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageLog;

public class EditionJsonProducer
extends AbstractJsonProducer {
    private Atlas atlas;
    private Lang lang;
    private String message;
    private MessageLog messageLog = null;
    private AtlasEditionReport atlasEditionReport;

    public EditionJsonProducer(Atlas atlas, Lang lang) {
        this.atlas = atlas;
        this.lang = lang;
    }

    public void setMessageLog(MessageLog messageLog) {
        this.messageLog = messageLog;
    }

    public void setReport(AtlasEditionReport atlasEditionReport) {
        this.atlasEditionReport = atlasEditionReport;
    }

    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("message").value((Object)"R\u00e9ussi !");
        if (this.messageLog != null) {
            jw.key("log").value((Object)LogUtils.toString((MessageLog)this.messageLog));
        }
        if (this.atlasEditionReport != null) {
            jw.key("report");
            jw.object();
            this.write(jw, this.atlasEditionReport);
            jw.endObject();
        }
        jw.endObject();
    }

    private void write(JSONWriter jw, AtlasEditionReport atlasEditionReport) throws IOException {
        Set<Motcle> motcleSet = atlasEditionReport.getCreationSet();
        if (!motcleSet.isEmpty()) {
            jw.key("creation");
            jw.array();
            for (Motcle motcle : motcleSet) {
                jw.object();
                TermJson.dataProperties(jw, this.atlas, motcle, this.lang);
                jw.endObject();
                jw.endArray();
            }
        }
    }
}

