/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.json;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.json.Extract;
import fr.exemole.bdfext.desmography.json.TermJson;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.json.CellJson;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;

public final class ResourceJson {
    private ResourceJson() {
    }

    public static void properties(JSONWriter jw, Atlas atlas, Extract extract, Lang lang, @Nullable CellConverter cellConverter, @Nullable PermissionSummary permissionSummary) throws IOException {
        jw.key("resources");
        jw.array();
        Iterator<SubsetItem> it = extract.getResourceIterator();
        while (it.hasNext()) {
            Map<IncludeKey, List<Integer>> indexationMap;
            SubsetItem resource = it.next();
            jw.object();
            jw.key("name").value((Object)ResourceJson.toKey(resource));
            if (resource instanceof FicheMeta) {
                FicheMeta ficheMeta = (FicheMeta)resource;
                jw.key("title").value((Object)ficheMeta.getTitre());
                if (permissionSummary != null) {
                    jw.key("editable").value(permissionSummary.canWrite(ficheMeta));
                }
            } else if (resource instanceof Motcle) {
                TermJson.labelProperties(jw, atlas, ((Motcle)resource).getLabels(), lang);
            } else {
                jw.key("title").value((Object)"");
            }
            if (cellConverter != null) {
                CellJson.cellArrayMappingProperty((JSONWriter)jw, (Cell[])cellConverter.toCellArray(resource), (String)"properties");
            }
            if ((indexationMap = extract.getIndexationMap(resource)) != null) {
                jw.key("indexation");
                jw.object();
                for (Map.Entry<IncludeKey, List<Integer>> indexationEntry : indexationMap.entrySet()) {
                    jw.key(indexationEntry.getKey().getKeyString());
                    jw.array();
                    for (Integer index : indexationEntry.getValue()) {
                        jw.value((Object)index);
                    }
                    jw.endArray();
                }
                jw.endObject();
            }
            jw.endObject();
        }
        jw.endArray();
    }

    public static String toKey(SubsetItem subsetItem) {
        return subsetItem.getSubsetKey() + "/" + subsetItem.getId();
    }
}

