/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.dom;

import fr.exemole.bdfext.desmography.DsmSpace;
import fr.exemole.bdfext.desmography.dsmd.dom.AttributeDOMReader;
import java.awt.Color;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class MotcleMatcher {
    private static final Attribute INACTIVE_ATTR = AttributeBuilder.toAttribute((AttributeKey)DsmSpace.ACTIVE_KEY, (String)"0");
    private final ThesaurusEditor termThesaurusEditor;
    private final Map<String, Motcle> descripteurMap = new HashMap<String, Motcle>();
    private final Map<String, Motcle> familleMap = new HashMap<String, Motcle>();
    private final Map<String, Motcle> grilleMap = new HashMap<String, Motcle>();
    private final Map<String, Map<String, Motcle>> contexteMapOfMap = new HashMap<String, Map<String, Motcle>>();
    private int gridAvailableId = 9101;
    private int sectorAvailableId = 9201;
    private int familyAvailableId = 9301;
    private int descripteurAvailableId = 9401;

    public MotcleMatcher(ThesaurusEditor termThesaurusEditor) {
        this.termThesaurusEditor = termThesaurusEditor;
    }

    public ThesaurusEditor getThesaurusEditor() {
        return this.termThesaurusEditor;
    }

    public ThesaurusMetadataEditor getThesaurusMetadataEditor() {
        return this.termThesaurusEditor.getThesaurusMetadataEditor();
    }

    public FichothequeEditor getFichothequeEditor() {
        return this.termThesaurusEditor.getFichothequeEditor();
    }

    public Thesaurus getThesaurus() {
        return this.termThesaurusEditor.getThesaurus();
    }

    public ThesaurusMetadata getThesaurusMetadata() {
        return this.termThesaurusEditor.getThesaurus().getThesaurusMetadata();
    }

    public Motcle matchDescripteur(String iddesc, boolean create) {
        Motcle motcle = this.descripteurMap.get(iddesc);
        if (motcle != null) {
            return motcle;
        }
        if (!create) {
            return null;
        }
        try {
            try {
                int code = Integer.parseInt(iddesc);
                if (code < 9000) {
                    motcle = this.termThesaurusEditor.createMotcle(code, "_" + code);
                }
            }
            catch (NumberFormatException code) {
                // empty catch block
            }
            if (motcle == null) {
                motcle = this.termThesaurusEditor.createMotcle(this.descripteurAvailableId, iddesc);
                ++this.descripteurAvailableId;
            }
        }
        catch (ParseException | ExistingIdException eie) {
            throw new ShouldNotOccurException((Exception)eie);
        }
        this.descripteurMap.put(iddesc, motcle);
        return motcle;
    }

    public Motcle matchFamille(String idctxt, boolean create) {
        Motcle motcle = this.familleMap.get(idctxt);
        if (motcle != null) {
            return motcle;
        }
        if (!create) {
            return null;
        }
        try {
            try {
                int code = Integer.parseInt(idctxt);
                motcle = this.termThesaurusEditor.createMotcle(this.familyAvailableId, "_family_" + code);
                ++this.familyAvailableId;
            }
            catch (NumberFormatException code) {
                // empty catch block
            }
            if (motcle == null) {
                motcle = this.termThesaurusEditor.createMotcle(this.familyAvailableId, idctxt);
                ++this.familyAvailableId;
            }
        }
        catch (ParseException | ExistingIdException eie) {
            throw new ShouldNotOccurException((Exception)eie);
        }
        this.familleMap.put(idctxt, motcle);
        return motcle;
    }

    public Motcle matchGrille(String name, boolean create) {
        Motcle motcle = this.grilleMap.get(name);
        if (motcle != null) {
            return motcle;
        }
        if (!create) {
            return null;
        }
        try {
            motcle = this.termThesaurusEditor.createMotcle(this.gridAvailableId, name);
            ++this.gridAvailableId;
        }
        catch (ParseException | ExistingIdException eie) {
            throw new ShouldNotOccurException((Exception)eie);
        }
        this.grilleMap.put(name, motcle);
        return motcle;
    }

    public Motcle matchContexte(String grilleName, String idctxt, boolean create) {
        Motcle motcle;
        Map<String, Motcle> map = this.contexteMapOfMap.get(grilleName);
        if (map == null) {
            if (!create) {
                return null;
            }
            map = new HashMap<String, Motcle>();
            this.contexteMapOfMap.put(grilleName, map);
        }
        if ((motcle = map.get(idctxt)) != null) {
            return motcle;
        }
        if (!create) {
            return null;
        }
        try {
            motcle = this.termThesaurusEditor.createMotcle(this.sectorAvailableId, "_" + grilleName + "_" + idctxt);
            ++this.sectorAvailableId;
        }
        catch (ParseException | ExistingIdException eie) {
            throw new ShouldNotOccurException((Exception)eie);
        }
        map.put(idctxt, motcle);
        return motcle;
    }

    public Collection<Motcle> getGrids() {
        return this.grilleMap.values();
    }

    public void readTermContent(Element element, Motcle motcle) {
        DOMUtils.readChildren((Element)element, child -> {
            String tagName = child.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel((Element)child);
                    if (label != null) {
                        this.termThesaurusEditor.putLabel(motcle, label);
                    }
                }
                catch (ParseException label) {}
            } else if (tagName.equals("color")) {
                CleanedString cleanedString = XMLUtils.toCleanedString((Element)child);
                if (cleanedString != null) {
                    try {
                        Color.decode(cleanedString.toString());
                        Attribute attribute = AttributeBuilder.toAttribute((AttributeKey)DsmSpace.COLOR_KEY, (CleanedString)cleanedString);
                        this.termThesaurusEditor.getFichothequeEditor().putAttribute((Object)motcle, attribute);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (tagName.equals("attr")) {
                AttributeDOMReader.read(this, motcle, child);
            }
        });
        String activeBoolean = element.getAttribute("active");
        if (activeBoolean.equals("0")) {
            this.termThesaurusEditor.getFichothequeEditor().putAttribute((Object)motcle, INACTIVE_ATTR);
        }
    }
}

