/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.dom;

import fr.exemole.bdfext.desmography.dsmd.dom.AttributeDOMReader;
import fr.exemole.bdfext.desmography.dsmd.dom.MotcleMatcher;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class MetadataDOMReader {
    private MetadataDOMReader() {
    }

    public static void readMetadata(MotcleMatcher motcleMatcher, Element metadataElement) {
        DOMUtils.readChildren((Element)metadataElement, (Consumer)new MetadataConsumer(motcleMatcher));
    }

    private static class MetadataConsumer
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;

        private MetadataConsumer(MotcleMatcher motcleMatcher) {
            this.motcleMatcher = motcleMatcher;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("titre")) {
                DOMUtils.readChildren((Element)element, (Consumer)new TitreConsumer());
            } else if (tagName.equals("langs")) {
                LangsConsumer langsConsumer = new LangsConsumer();
                DOMUtils.readChildren((Element)element, (Consumer)langsConsumer);
                Langs langs = langsConsumer.toLangs();
                if (!langs.isEmpty()) {
                    this.motcleMatcher.getThesaurusMetadataEditor().setAuthorizedLangs(langs);
                }
            } else if (tagName.equals("attr")) {
                AttributeDOMReader.read(this.motcleMatcher, this.motcleMatcher.getThesaurusMetadata(), element);
            } else if (tagName.equals("attr-def")) {
                AttributeKey attributeKey = AttributeUtils.readAttributeKey((Element)element);
                if (attributeKey == null) {
                    return;
                }
                String activeString = element.getAttribute("active");
                if (activeString.equals("0")) {
                    // empty if block
                }
            }
        }

        private class TitreConsumer
        implements Consumer<Element> {
            private TitreConsumer() {
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("lib")) {
                    try {
                        Label label = LabelUtils.readLabel((Element)element);
                        if (label != null) {
                            MetadataConsumer.this.motcleMatcher.getThesaurusMetadataEditor().putTitle(label);
                            MetadataConsumer.this.motcleMatcher.getThesaurusMetadataEditor().putLabel("desmography.title", label);
                        }
                    }
                    catch (ParseException parseException) {}
                } else if (tagName.equals("attr")) {
                    AttributeDOMReader.read(MetadataConsumer.this.motcleMatcher, MetadataConsumer.this.motcleMatcher.getThesaurusMetadata(), element);
                }
            }
        }

        private class LangsConsumer
        implements Consumer<Element> {
            private final Set<Lang> langSet = new LinkedHashSet<Lang>();

            private LangsConsumer() {
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("lang")) {
                    String langString = DOMUtils.readSimpleElement((Element)element);
                    if (langString.length() == 0) {
                        return;
                    }
                    try {
                        Lang langInteger = Lang.parse((String)langString);
                        this.langSet.add(langInteger);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }

            public Langs toLangs() {
                return LangsUtils.fromCollection(this.langSet);
            }
        }
    }
}

