/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.dom;

import fr.exemole.bdfext.desmography.atlas.RelationEditor;
import fr.exemole.bdfext.desmography.dsmd.dom.MotcleMatcher;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class DescripteursDOMReader {
    private DescripteursDOMReader() {
    }

    public static void createTerms(Element descripteursElement, MotcleMatcher motcleMatcher) {
        DOMUtils.readChildren((Element)descripteursElement, (Consumer)new TermCreationStep(motcleMatcher));
    }

    public static void populateTerms(Element descripteursElement, MotcleMatcher motcleMatcher) {
        DOMUtils.readChildren((Element)descripteursElement, (Consumer)new ContentStep(motcleMatcher));
    }

    public static void addToFamily(Element descripteursElement, MotcleMatcher motcleMatcher, RelationEditor relationEditor) {
        DOMUtils.readChildren((Element)descripteursElement, (Consumer)new FamilyStep(motcleMatcher, relationEditor));
    }

    private static Motcle getDescripteur(Element element, MotcleMatcher motcleMatcher, boolean create) {
        if (!element.getTagName().equals("descripteur")) {
            return null;
        }
        String iddescString = element.getAttribute("iddesc");
        if (iddescString.length() == 0) {
            return null;
        }
        return motcleMatcher.matchDescripteur(iddescString, create);
    }

    private static class TermCreationStep
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;

        private TermCreationStep(MotcleMatcher motcleMatcher) {
            this.motcleMatcher = motcleMatcher;
        }

        @Override
        public void accept(Element element) {
            DOMUtils.readChildren((Element)element, child -> {
                Motcle descripteur = DescripteursDOMReader.getDescripteur(child, this.motcleMatcher, true);
            });
        }
    }

    private static class ContentStep
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;

        private ContentStep(MotcleMatcher motcleMatcher) {
            this.motcleMatcher = motcleMatcher;
        }

        @Override
        public void accept(Element element) {
            DOMUtils.readChildren((Element)element, child -> {
                Motcle descripteur = DescripteursDOMReader.getDescripteur(child, this.motcleMatcher, false);
                if (descripteur != null) {
                    this.motcleMatcher.readTermContent((Element)child, descripteur);
                }
            });
        }
    }

    private static class FamilyStep
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;
        private final RelationEditor relationEditor;

        private FamilyStep(MotcleMatcher motcleMatcher, RelationEditor relationEditor) {
            this.motcleMatcher = motcleMatcher;
            this.relationEditor = relationEditor;
        }

        @Override
        public void accept(Element element) {
            if (element.getTagName().equals("infamille")) {
                String idctxt = element.getAttribute("idctxt");
                Motcle famille = this.motcleMatcher.matchFamille(idctxt, false);
                if (famille == null) {
                    return;
                }
                ArrayList<Motcle> descripteurList = new ArrayList<Motcle>();
                DOMUtils.readChildren((Element)element, child -> {
                    Motcle descripteur = DescripteursDOMReader.getDescripteur(child, this.motcleMatcher, false);
                    if (descripteur != null) {
                        descripteurList.add(descripteur);
                    }
                });
                this.relationEditor.addToFamily(famille, descripteurList);
            }
        }
    }
}

