/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import java.util.Collections;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.annotation.Nullable;

public class RelationReference {
    public static final String SPECIAL_TYPE = "special";
    public static final String SUBSECTORS_TYPE = "subsectors";
    public static final String RELATION_TYPE = "relation";
    public static final String UNKNOWN_TYPE = "unknown";
    public static final String ALL_SPECIAL = "all";
    public static final String GRIDS_SPECIAL = "grids";
    public static final String NONE_SPECIAL = "none";
    public static final String ROOTFAMILIES_SPECIAL = "rootfamilies";
    public static final String ROOTSECTORS_SPECIAL = "rootsectors";
    public static final String SUBSECTORS_PREFIX = "subsectors:";
    private static final List<FicheMeta> EMPTY_RELATIONLIST = Collections.emptyList();
    private final String type;
    private final String name;
    private final List<FicheMeta> relationList;
    private final Motcle term;

    private RelationReference(String type, String name, @Nullable FicheMeta relation) {
        this(type, name, relation, null);
    }

    private RelationReference(String type, String name, @Nullable FicheMeta relation, @Nullable Motcle term) {
        this.type = type;
        this.name = name;
        this.relationList = relation != null ? Collections.singletonList(relation) : EMPTY_RELATIONLIST;
        this.term = term;
    }

    private RelationReference(String type, String name, List<FicheMeta> relationList, @Nullable Motcle term) {
        this.type = type;
        this.name = name;
        this.relationList = relationList;
        this.term = term;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Motcle getTerm() {
        return this.term;
    }

    public List<FicheMeta> getRelationList() {
        return this.relationList;
    }

    public static RelationReference build(String name, Atlas atlas) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (name) {
            case "all": {
                return new RelationReference(SPECIAL_TYPE, name, null);
            }
            case "rootfamilies": {
                return new RelationReference(SPECIAL_TYPE, name, AtlasUtils.getRootFamiliesRelation(atlas));
            }
            case "grids": {
                return new RelationReference(SPECIAL_TYPE, name, AtlasUtils.getGridsRelation(atlas));
            }
            case "none": {
                return new RelationReference(SPECIAL_TYPE, name, null);
            }
            case "rootsectors": {
                return new RelationReference(SPECIAL_TYPE, name, AtlasUtils.getRootSectorsRelationList(atlas), null);
            }
        }
        if (name.startsWith(SUBSECTORS_PREFIX)) {
            String idString = name.substring(SUBSECTORS_PREFIX.length());
            try {
                int termId = Integer.parseInt(idString);
                Motcle term = atlas.getTermThesaurus().getMotcleById(termId);
                if (term != null) {
                    List<FicheMeta> relationList = AtlasUtils.getRelationList(atlas, term, "superior", SUBSECTORS_TYPE);
                    return new RelationReference(SUBSECTORS_TYPE, name, relationList, term);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                FicheMeta relation = atlas.getRelationCorpus().getFicheMetaById(Integer.parseInt(name));
                return new RelationReference(RELATION_TYPE, name, relation);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new RelationReference(UNKNOWN_TYPE, name, null);
    }
}

