/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasBuilder;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.L10nEngine;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.MetadataEditor;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.FieldGeneration;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.namespaces.SyncSpace;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.corpus.FieldGenerationParser;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.SimpleLineMessageHandler;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Labels;

public final class DesmographyUtils {
    public static final AttributeKey SYNC_ATLAS_KEY = AttributeKey.build((CheckedNameSpace)SyncSpace.SYNC_NAMESPACE, (CharSequence)"atlas");

    private DesmographyUtils() {
    }

    public static String getAtlasSyncUrl(Atlas atlas) {
        return atlas.getTermThesaurus().getMetadata().getAttributes().getFirstValue(SYNC_ATLAS_KEY);
    }

    public static String getMandatoryValue(RequestMap requestMap, String paramName) throws ErrorMessageException {
        String value = requestMap.getParameter(paramName);
        if (value == null || value.isEmpty()) {
            throw BdfErrors.emptyMandatoryParameter((String)paramName);
        }
        return value;
    }

    public static boolean isAtlasThesaurus(Thesaurus thesaurus) {
        Corpus relationCorpus = DesmographyUtils.getRelationCorpus(thesaurus);
        return relationCorpus != null;
    }

    public static boolean isCandidateThesaurus(Thesaurus thesaurus) {
        Corpus relationCorpus = DesmographyUtils.getRelationCorpus(thesaurus);
        return relationCorpus == null;
    }

    public static SortedMap<String, Thesaurus> getAtlasThesaurusMap(Fichotheque fichotheque) {
        TreeMap<String, Thesaurus> thesaurusMap = new TreeMap<String, Thesaurus>();
        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
            if (!DesmographyUtils.isAtlasThesaurus(thesaurus)) continue;
            thesaurusMap.put(thesaurus.getSubsetName(), thesaurus);
        }
        return thesaurusMap;
    }

    public static SortedMap<String, Thesaurus> getCandidateThesaurusMap(Fichotheque fichotheque) {
        TreeMap<String, Thesaurus> thesaurusMap = new TreeMap<String, Thesaurus>();
        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
            if (!DesmographyUtils.isCandidateThesaurus(thesaurus)) continue;
            thesaurusMap.put(thesaurus.getSubsetName(), thesaurus);
        }
        return thesaurusMap;
    }

    public static Corpus createRelationCorpus(FichothequeEditor fichothequeEditor, BdfServerEditor bdfServerEditor, Thesaurus thesaurus) {
        CorpusEditor relationCorpusEditor;
        SubsetKey thesaurusKey = thesaurus.getSubsetKey();
        L10nEngine l10nEngine = L10nEngine.init((BdfServer)bdfServerEditor.getBdfServer());
        SubsetKey corpusKey = SubsetKey.build((short)1, (String)(thesaurusKey.getSubsetName() + "relation"));
        try {
            relationCorpusEditor = fichothequeEditor.createCorpus(corpusKey, null);
        }
        catch (ExistingSubsetException ese) {
            return (Corpus)fichothequeEditor.getFichotheque().getSubset(corpusKey);
        }
        CorpusMetadataEditor relationCorpusMetadataEditor = relationCorpusEditor.getCorpusMetadataEditor();
        l10nEngine.populate((MetadataEditor)relationCorpusMetadataEditor, null, "_ label.desmography.relation_title", thesaurus.getSubsetName(), new Labels[]{thesaurus.getThesaurusMetadata().getTitleLabels()});
        l10nEngine.populate((MetadataEditor)relationCorpusMetadataEditor, "fiche", "_ label.desmography.relation_fiche");
        l10nEngine.populate((MetadataEditor)relationCorpusMetadataEditor, "newfiche", "_ label.desmography.relation_newfiche");
        relationCorpusMetadataEditor.setFieldGeneration(DesmographyUtils.getFieldGeneration(thesaurusKey));
        CorpusField langField = ((CorpusMetadata)relationCorpusMetadataEditor.getMetadata()).getCorpusField(FieldKey.LANG);
        try {
            relationCorpusMetadataEditor.setFieldOption(langField, "langScope", (Object)"list");
            Lang[] array = new Lang[]{Lang.build((String)"zxx")};
            relationCorpusMetadataEditor.setFieldOption(langField, "langArray", (Object)array);
        }
        catch (FieldOptionException foe) {
            throw new ImplementationException((Exception)((Object)foe));
        }
        UiComponents mainUiComponents = bdfServerEditor.getBdfServer().getUiManager().getMainUiComponents(relationCorpusEditor.getCorpus());
        IncludeKey superior = IncludeKey.newInstance((SubsetKey)thesaurusKey, (String)"superior", (int)-1);
        IncludeKey sector = IncludeKey.newInstance((SubsetKey)thesaurusKey, (String)"sector", (int)-1);
        IncludeKey inferior = IncludeKey.newInstance((SubsetKey)thesaurusKey, (String)"inferior", (int)-1);
        bdfServerEditor.putComponentUi(mainUiComponents, (UiComponent)DesmographyUtils.initBuilder(superior, l10nEngine, "_ label.desmography.include_superior").toIncludeUi());
        bdfServerEditor.putComponentUi(mainUiComponents, (UiComponent)DesmographyUtils.initBuilder(sector, l10nEngine, "_ label.desmography.include_sector").toIncludeUi());
        bdfServerEditor.putComponentUi(mainUiComponents, (UiComponent)DesmographyUtils.initBuilder(inferior, l10nEngine, "_ label.desmography.include_inferior").putOption("inputRows", (Object)"15").putOption("inputWidth", (Object)"large").putOption("inputType", (Object)"text").toIncludeUi());
        bdfServerEditor.putComponentUi(mainUiComponents, (UiComponent)IncludeUiBuilder.initSpecial((String)"liage").setStatus("obsolete").toIncludeUi());
        String[] positionArray = new String[]{superior.getKeyString(), sector.getKeyString(), inferior.getKeyString(), "redacteurs"};
        bdfServerEditor.setPositionArray(mainUiComponents, positionArray);
        return relationCorpusEditor.getCorpus();
    }

    private static FieldGeneration getFieldGeneration(SubsetKey thesaurusKey) {
        String rawString = "titre\n" + DesmographySpace.RELATIONTYPE_KEY + ",thesaurus_" + thesaurusKey.getSubsetName() + "_superior,thesaurus_" + thesaurusKey.getSubsetName() + "_sector\n{value}||{idalpha}||{id}\nsep1_2=\"|\",sep2=\",\",sep2_3=\"|\",sep3=\",\"";
        return FieldGenerationParser.parse((String)rawString, (LineMessageHandler)new SimpleLineMessageHandler());
    }

    private static IncludeUiBuilder initBuilder(IncludeKey includeKey, L10nEngine l10nEngine, String messageKey) {
        IncludeUiBuilder builder = IncludeUiBuilder.initSubset((ExtendedIncludeKey)ExtendedIncludeKey.newInstance((IncludeKey)includeKey));
        l10nEngine.populate(builder, messageKey);
        return builder;
    }

    public static Atlas getAtlas(RequestHandler requestHandler) throws ErrorMessageException {
        String atlasName = requestHandler.getMandatoryParameter("atlas");
        Fichotheque fichotheque = requestHandler.getFichotheque();
        Thesaurus termThesaurus = FichothequeUtils.getThesaurus((Fichotheque)fichotheque, (String)atlasName);
        if (termThesaurus == null) {
            throw BdfErrors.error((String)"_ error.unknown.thesaurus", (Object[])new Object[]{atlasName});
        }
        Corpus relationCorpus = DesmographyUtils.getRelationCorpus(termThesaurus);
        if (relationCorpus == null) {
            throw BdfErrors.error((String)"_ error.unknown.corpus", (Object[])new Object[]{atlasName + "relation"});
        }
        return AtlasBuilder.build(requestHandler.getBdfServer(), termThesaurus, relationCorpus);
    }

    public static Atlas getAtlas(BdfServer bdfServer, String atlasName) throws ErrorMessageException {
        Fichotheque fichotheque = bdfServer.getFichotheque();
        Thesaurus termThesaurus = FichothequeUtils.getThesaurus((Fichotheque)fichotheque, (String)atlasName);
        if (termThesaurus == null) {
            throw new ErrorMessageException("_ error.unknown.thesaurus", new Object[]{atlasName});
        }
        Corpus relationCorpus = DesmographyUtils.getRelationCorpus(termThesaurus);
        if (relationCorpus == null) {
            throw new ErrorMessageException("_ error.unknown.corpus", new Object[]{atlasName + "relation"});
        }
        return AtlasBuilder.build(bdfServer, termThesaurus, relationCorpus);
    }

    public static Corpus getRelationCorpus(Thesaurus thesaurus) {
        return FichothequeUtils.getCorpus((Fichotheque)thesaurus.getFichotheque(), (String)(thesaurus.getSubsetName() + "relation"));
    }
}

