/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography;

import java.util.AbstractList;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.text.CleanedString;

public final class DesmographySpace {
    public static final CheckedNameSpace NAMESPACE = CheckedNameSpace.build((CharSequence)"desmography");
    public static final AttributeKey ACTIVE_KEY = AttributeKey.build((CheckedNameSpace)NAMESPACE, (CharSequence)"active");
    public static final AttributeKey RELATIONTYPE_KEY = AttributeKey.build((CheckedNameSpace)NAMESPACE, (CharSequence)"relationtype");
    public static final AttributeKey TABLEEXPORT_KEY = AttributeKey.build((CheckedNameSpace)NAMESPACE, (CharSequence)"tableexport");
    public static final AttributeKey CONFIRMATIONWORD_KEY = AttributeKey.build((CheckedNameSpace)NAMESPACE, (CharSequence)"confirmationword");
    public static final AttributeKey HOME_KEY = AttributeKey.build((CheckedNameSpace)NAMESPACE, (CharSequence)"home");
    public static final AttributeKey ROSETTE_DEFAULT_KEY = AttributeKey.build((CheckedNameSpace)NAMESPACE, (CharSequence)"rosette.default");
    public static final Attribute ROOTFAMILIES_ATTR = new RelationTypeAttribute("rootfamilies");
    public static final Attribute GRIDS_ATTR = new RelationTypeAttribute("grids");
    public static final Attribute SUBSECTORS_ATTR = new RelationTypeAttribute("subsectors");
    public static final Attribute SUBFAMILIES_ATTR = new RelationTypeAttribute("subfamilies");
    public static final Attribute FAMILY_ATTR = new RelationTypeAttribute("family");
    public static final Attribute HIERARCHY_ATTR = new RelationTypeAttribute("hierarchy");

    private DesmographySpace() {
    }

    public static Attribute getAttribute(String relationType) {
        switch (relationType) {
            case "rootfamilies": {
                return ROOTFAMILIES_ATTR;
            }
            case "grids": {
                return GRIDS_ATTR;
            }
            case "subsectors": {
                return SUBSECTORS_ATTR;
            }
            case "subfamilies": {
                return SUBFAMILIES_ATTR;
            }
            case "family": {
                return FAMILY_ATTR;
            }
            case "hierarchy": {
                return HIERARCHY_ATTR;
            }
        }
        CleanedString cleanedString = CleanedString.newInstance((CharSequence)relationType);
        if (cleanedString != null) {
            return new RelationTypeAttribute(cleanedString.toString());
        }
        return null;
    }

    private static class RelationTypeAttribute
    extends AbstractList<String>
    implements Attribute {
        private final String value;

        private RelationTypeAttribute(String value) {
            this.value = value;
        }

        public AttributeKey getAttributeKey() {
            return RELATIONTYPE_KEY;
        }

        public String getFirstValue() {
            return this.value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String get(int i) {
            return this.value;
        }
    }
}

