/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography;

import fr.exemole.bdfext.desmography.commands.ActivationCommand;
import fr.exemole.bdfext.desmography.commands.ConversionCommand;
import fr.exemole.bdfext.desmography.commands.DsmdImportCommand;
import fr.exemole.bdfext.desmography.commands.DsmdUpdateCommand;
import fr.exemole.bdfext.desmography.commands.ParameterCommand;
import fr.exemole.bdfext.desmography.commands.SyncCommand;
import fr.exemole.bdfext.desmography.commands.TermAddCommand;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import net.mapeadores.util.request.RequestMap;

public class DesmographyBdfCommandProvider
implements BdfCommandProvider {
    public BdfCommand getBdfCommand(BdfCommandParameters bdfCommandParameters) {
        if (!BdfInstructionUtils.ownsToExtension((BdfCommandParameters)bdfCommandParameters, (String)"desmography")) {
            return null;
        }
        BdfServer bdfServer = bdfCommandParameters.getBdfServer();
        RequestMap requestMap = bdfCommandParameters.getRequestMap();
        switch (bdfCommandParameters.getCommandName()) {
            case "Activation": {
                return new ActivationCommand(bdfServer, requestMap);
            }
            case "DsmdImport": {
                return new DsmdImportCommand(bdfServer, requestMap);
            }
            case "DsmdUpdate": {
                return new DsmdUpdateCommand(bdfServer, requestMap);
            }
            case "TermAdd": {
                return new TermAddCommand(bdfServer, requestMap);
            }
            case "Conversion": {
                return new ConversionCommand(bdfServer, requestMap);
            }
            case "Parameter": {
                return new ParameterCommand(bdfServer, requestMap);
            }
            case "Sync": {
                return new SyncCommand(bdfServer, requestMap);
            }
        }
        return null;
    }
}

