/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.dsmd.crtxml;

import java.net.MalformedURLException;
import java.net.URL;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.text.CleanedString;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferencesDOMReader {
    private AtlasEditor atlasEditor;
    private Atlas atlas;

    public ReferencesDOMReader(AtlasEditor atlasEditor) {
        this.atlasEditor = atlasEditor;
        this.atlas = atlasEditor.getAtlas();
    }

    public void read(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Element el;
            String tagname;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || !(tagname = (el = (Element)nd).getTagName()).equals("link")) continue;
            this.readLink(el);
        }
    }

    private void readLink(Element element_xml) {
        CleanedString href;
        Descripteur descripteur = null;
        String iddescString = element_xml.getAttribute("iddesc");
        if (iddescString.length() > 0) {
            Iddesc iddesc = Iddesc.parse(iddescString);
            descripteur = this.atlas.getDescripteurs().getDescripteurByIddesc(iddesc);
        }
        if (descripteur != null && (href = CleanedString.newInstance((CharSequence)element_xml.getAttribute("href"))) != null) {
            try {
                new URL(href.toString());
                this.atlasEditor.putAttribute(descripteur, AttributeBuilder.toAttribute((AttributeKey)AtlasAttributes.URL_KEY, (CleanedString)href));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

